using System;
using System.Data;
using NDac.Datas;
using NDac.Keys;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// エンティティの抽象クラスを表します。
	/// </summary>
	public abstract partial class Entity : IEntity< IKey >
	{
		/// <summary>
		/// データセットホルダーを取得します。
		/// </summary>
		/// <returns>データセットホルダー</returns>
		public DataSetHolder GetHolder()
		{
			try
			{
				return( this._row.Table.DataSet.GetHolder() );
			}
			catch
			{
				return( null );
			}
		}

		/// <summary>
		/// データセットを取得します。
		/// </summary>
		/// <returns>データセット</returns>
		public DataSet GetDataSet()
		{
			try
			{
				return( this._row.Table.DataSet );
			}
			catch
			{
				return( null );
			}
		}

		/// <summary>
		/// データテーブルを取得します。
		/// </summary>
		/// <returns>データテーブル</returns>
		public DataTable GetTable()
		{
			try
			{
				return( this._row.Table );
			}
			catch
			{
				return( null );
			}
		}
	}
}
