using System;
using System.Data;
using NDac.Datas;
using NDac.Datas.Extensions;

namespace System.Data
{
	/// <summary>
	/// データセットの拡張メソッドのクラスを表します。
	/// </summary>
	public static class DataSetExtension
	{
		/// <summary>
		/// データセットホルダーを取得します。
		/// </summary>
		/// <param name="ds">データセット</param>
		/// <returns>データセットホルダー</returns>
		public static DataSetHolder GetHolder( this DataSet ds )
		{
			if( ( ds.Site != null ) && ( ds.Site is DataSetHolderSite ) )
			{
				DataSetHolderSite site = ( DataSetHolderSite )ds.Site;

				return( site.Component.Holder );
			}
			else
			{
				return( null );
			}
		}
	}
}
