﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NDac.Datas;
using NDac.Gateways;
using NDac.IdentityMappings;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.DataTransferObjects;
using NDac.Modules.Entities;
using NDac.RemoteFacades;

namespace NDac.Sample
{
	public partial class SampleForm : Form
	{
		/*
		 * NDacGenerateフォルダ以下は自動生成されたプログラムです。
		 * NDacPartialsフォルダ以下は差分実装側です。※namespaceは自動生成と同じNDacに変更しています。
		 * 
		 * 差分実装は行わなくても使用出来ますがプロジェクトで使い易くするためには、基本的に以下の実装を行ってください。
		 * ・DataSetHolderのデフォルトコンストラクタでよびだされるFillDefaultConnectionStringの実装（接続文字列を渡すのが面倒くさいため）
		 * ・[TableName]GatewayのLoadBy( XxxxKey )メソッドで使用する検索条件クラスXxxxKeyの追加
		 * ・[TableName]GatewayのLoadBy( XxxxKey )メソッドの実装
		 * ・[TableName]Entityの外部キーアクセスの実装（※これは必須ではありませんが、サンプルで簡易実装しています。）
		 * ・[TableName]ModuleのSelectBy( XxxxKey )メソッドの実装（※これは必須ではありませんが、DataSetをインメモリＤＢとして使用する場合は実装すると楽になると思います。）
		 */

		//Server=TESTDB-SERVER\SQL2005; UID=sa; PWD=sql; Initial Catalog=SandBox

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public SampleForm()
		{
			InitializeComponent();
		}

		/// <summary>
		/// 接続文字列の入力変更イベントを表します。
		/// </summary>
		/// <param name="sender">イベント送信者</param>
		/// <param name="e">パラメータ</param>
		private void connectionStringTextBox_TextChanged( object sender, EventArgs e )
		{
			//画面に入力された情報をスタティッククラスに記憶しています。
			//DataSetHolderのPartialメソッド実装側で使用しています。
			ConfigurationMock.ConnectionString = this.connectionStringTextBox.Text;
		}

		/// <summary>
		/// サンプルデータを登録する処理を表します。
		/// </summary>
		/// <param name="sender">イベント送信者</param>
		/// <param name="e">パラメータ</param>
		private void executeSetupButton_Click( object sender, EventArgs e )
		{
			try
			{
				this.ClearData();

				this.InsertSetupData();
			}
			catch( Exception ex )
			{
				MessageBox.Show( ex.Message );
			}
		}

		/// <summary>
		/// データ取得のサンプルを表します。
		/// </summary>
		/// <param name="sender">イベント送信者</param>
		/// <param name="e">パラメータ</param>
		private void executeSelectButton_Click( object sender, EventArgs e )
		{
			try
			{
				//データ取得のサンプルです。
				if( true )
				{
					//RemoteFacadeを使用したサンプルです。通常プロジェクトではこちらを推奨
					this.resultDataGridView.DataSource = new BookFacade( this.GetKey() ).ToEntities();
				}
				else
				{
					//PofEAAの基本的な使い方のサンプルです。
					DataSetHolder	holder	= new DataSetHolder();

					BookGateway		gateway	= new BookGateway( holder );

					BookModule		module	= new BookModule( holder );

					( ( ITableDataGateway )gateway ).LoadBy( this.GetKey() );

					this.resultDataGridView.DataSource = module.ToEntities();
				}
			}
			catch( Exception ex )
			{
				MessageBox.Show( ex.Message );
			}
		}

		/// <summary>
		/// データをクリアします。
		/// </summary>
		public void ClearData()
		{
			TableTruncater truncater = new TableTruncater( ConfigurationMock.ConnectionString );

			truncater.ExecuteAll();
		}

		/// <summary>
		/// データ取得用のキーオブジェクトを取得します。
		/// <para>呼出し元でポリモルフィックに振舞っているのを表現するためにあえてリファクタしていません。</para>
		/// </summary>
		/// <returns>キーオブジェクト</returns>
		public IKey GetKey()
		{
			if( ( this.titleTextBox.Text.Length == 0 ) && ( this.autherTextBox.Text.Length == 0 ) && ( this.publisherTextBox.Text.Length == 0 ) && ( this.isbnTextBox.Text.Length == 0 ) )
			{
				return( new LoadAllKey() );
			}
			else if( ( this.titleTextBox.Text.Length != 0 ) && ( this.autherTextBox.Text.Length == 0 ) && ( this.publisherTextBox.Text.Length == 0 ) && ( this.isbnTextBox.Text.Length == 0 ) )
			{
				return( new NameLikeSelectKey( this.titleTextBox.Text ) );
			}
			else if( ( this.titleTextBox.Text.Length == 0 ) && ( this.autherTextBox.Text.Length != 0 ) && ( this.publisherTextBox.Text.Length == 0 ) && ( this.isbnTextBox.Text.Length == 0 ) )
			{
				return( null );
			}
			else if( ( this.titleTextBox.Text.Length == 0 ) && ( this.autherTextBox.Text.Length == 0 ) && ( this.publisherTextBox.Text.Length != 0 ) && ( this.isbnTextBox.Text.Length == 0 ) )
			{
				return( new PublisherNameLikeSelectKey( this.publisherTextBox.Text ) );
			}
			else if( ( this.titleTextBox.Text.Length == 0 ) && ( this.autherTextBox.Text.Length == 0 ) && ( this.publisherTextBox.Text.Length == 0 ) && ( this.isbnTextBox.Text.Length != 0 ) )
			{
				return( new IsbnSelectKey( long.Parse( this.isbnTextBox.Text ) ) );
			}

			return( null );
		}

		/// <summary>
		/// テーブルにデータを挿入する場合のサンプルです。
		/// </summary>
		public void InsertSetupData()
		{
			DataSetHolder holder = new DataSetHolder();

			this.FillAuthor( holder );

			this.FillPublisher( holder );

			this.FillBook( holder );

			holder.Update();
		}

		/// <summary>
		/// データセットホルダーに著者データを充填します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public void FillAuthor( DataSetHolder holder )
		{
			AuthorFacade facade = new AuthorFacade( holder );

			facade.Insert( new AuthorDTO()
				{
					Id = 1,
					Name = "ケント・ベック",
					Sex = 1,
				} );

			facade.Insert( new AuthorDTO()
				{
					Id = 2,
					Name = "マーチン・ファウラー",
					Sex = 1,
				} );

			IdNumberingFacade idFacade = new IdNumberingFacade( holder );

			idFacade.Insert( new IdNumberingDTO()
				{
					TableName = facade.TableName,									//= AuthorFacade.AccessTableName でも可
					NextId = facade[ new IndexNumber( facade.Count - 1 ) ].Id + 1,	//= facade.Count + 1 でも可
				} );
		}

		/// <summary>
		/// データセットホルダーに出版社データを充填します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public void FillPublisher( DataSetHolder holder )
		{
			PublisherFacade facade = new PublisherFacade( holder );

			facade.Insert( new PublisherDTO()
				{
					Id = 1,
					Name = "翔泳社",
				} );

			facade.Insert( new PublisherDTO()
				{
					Id = 2,
					Name = "ピアソン・エデュケーション",
				} );

			IdNumberingFacade idFacade = new IdNumberingFacade( holder );

			idFacade.Insert( new IdNumberingDTO()
				{
					TableName = facade.TableName,
					NextId = facade[ new IndexNumber( facade.Count - 1 ) ].Id + 1,
				} );
		}

		/// <summary>
		/// データセットホルダーに本データを充填します。
		/// </summary>
		/// <param name="holder">データセットホルダー</param>
		public void FillBook( DataSetHolder holder )
		{
			BookFacade facade = new BookFacade( holder );

			facade.Insert( new BookDTO()
				{
					Id = 1,
					Title = "エンタープライズアプリケーションアーキテクチャ",
					Price = 6090,
					Isbn = 4798105538,
					AuthorId = 2,
					PublisherId = 1,
				} );

			IdNumberingFacade idFacade = new IdNumberingFacade( holder );

			idFacade.Insert( new IdNumberingDTO()
				{
					TableName = facade.TableName,
					NextId = facade[ new IndexNumber( facade.Count - 1 ) ].Id + 1,
				} );
		}

		private void createConnectionStringButton_Click( object sender, EventArgs e )
		{
			ConnectSqlClientDialog dialog = new ConnectSqlClientDialog();

			if( dialog.ShowDialog() == DialogResult.OK )
			{
				this.connectionStringTextBox.Text = dialog.ConnectionString;
			}
		}
	}
}
