﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NDac.IdentityMappings;
using NDac.RemoteFacades;
using NDac.Keys;
using NDac.Datas;
using NDac.Gateways;

namespace NDac.Modules.Entities
{
	/*このクラスは自動生成されたBookEntityにメソッド、プロパティを追記するためのものです。*/
	partial class BookEntity
	{
		/// <summary>
		/// 著者名を表します。リモートファサードでの取得方法です。
		/// </summary>
		public string AuthorName
		{
			get
			{
				//インデックスアクセスのサンプル

				AuthorEntity author = new AuthorFacade( new AuthorKey( this.AuthorId ) )[ IndexNumber.Zero ];

				return( string.Format( "{0}", author.Name ) );
			}
		}

		/// <summary>
		/// 出版社名を表します。リモートファサードでの取得方法です。
		/// </summary>
		public string PublisherName
		{
			get
			{
				//キーオブジェクトアクセスのサンプル

				PublisherKey	primaryKey	= new PublisherKey( this.PublisherId );

				PublisherEntity	publisher	= new PublisherFacade( primaryKey )[ primaryKey ];

				return( publisher.Name );
			}
		}

		/// <summary>
		/// 出版社名を表します。一意マッピングでの取得方法です。
		/// </summary>
		public string PublisherNameByゲートウェイAndテーブルモジュール
		{
			get
			{
				DataSetHolder		holder		= new DataSetHolder();
 
				PublisherGateway	gateway		= new PublisherGateway( holder );

				PublisherModule		module		= new PublisherModule( holder );

				PublisherKey		primaryKey	= new PublisherKey( this.PublisherId );

				gateway.LoadBy( primaryKey ); //gateway.LoadBy( this.PublisherId ); こちらでも可（プライマリキーは値渡しもサポートしている）

				return( module[ primaryKey ].Name );
			}
		}

		/// <summary>
		/// 出版社名を表します。一意マッピングでの取得方法です。
		/// </summary>
		public string PublisherNameBy一意マッピング経由
		{
			get
			{
				return( PublisherFinder.Instance.Find( this.PublisherId ).Name );
			}
		}
	}
}
