﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NDac.Keys
{
	/// <summary>
	/// ISBNコード検索キーを表します。
	/// </summary>
	public class IsbnSelectKey : Key
	{
		private long _isbn;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="isbn">ISBNコード</param>
		public IsbnSelectKey( long isbn )
		{
			this._isbn = isbn;
		}

		/// <summary>
		/// ISBNコードを表します。
		/// </summary>
		public long Isbn
		{
			get
			{
				return( this._isbn );
			}
		}
	}
}
