using System;
using System.Data;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;

namespace NDac.Modules.Entities
{
	/// <summary>
	/// IdNumberingテーブルのエンティティを表します。
	/// </summary>
	public partial class IdNumberingEntity : Entity< IdNumberingKey >
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="row">データテーブル</param>
		public IdNumberingEntity( DataRow row )
			: base( row )
		{
		}

		/// <summary>
		/// TableNameを表します。
		/// </summary>
		[ PrimaryKey( "TableName", typeof( string ) ) ]
		public string TableName
		{
			get
			{
				return( ( this._row[ "TableName" ] == DBNull.Value ) ? default( string ) : StringCutDowner.Variable( ( string )this._row[ "TableName" ], 100 ) );
			}
			set
			{
				this._row[ "TableName" ] = ( value == null ? ( object )DBNull.Value : StringCutDowner.Variable( value, 100 ) );
			}
		}

		/// <summary>
		/// NextIdを表します。
		/// </summary>
		public long NextId
		{
			get
			{
				return( ( this._row[ "NextId" ] == DBNull.Value ) ? default( long ) : ( long )this._row[ "NextId" ] );
			}
			set
			{
				this._row[ "NextId" ] = value;
			}
		}

		/// <summary>
		/// エンティティの内容をコピーします。この操作は値のみのコピーです。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public void Copy( IdNumberingEntity source )
		{
			base.Copy( source );
		}

		/// <summary>
		/// プライマリキーに取得します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override IdNumberingKey ToPrimaryKey()
		{
			return( new IdNumberingKey( this.TableName ) );
		}
	}
}
