﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;

namespace NDac.Sample
{
	public partial class ConnectSqlClientDialog : Form
	{
		private string _connectionString;

		public ConnectSqlClientDialog()
		{
			InitializeComponent();
		}

		public string ConnectionString
		{
			get
			{
				return( this._connectionString );
			}
		}

		private void createButton_Click( object sender, EventArgs e )
		{
			this._connectionString = this.CreateConnectionStringToServer() + ";Initial Catalog=" + this.databaseComboBox.Text;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private string CreateConnectionStringToServer()
		{
			if( this.authenticationComboBox.SelectedIndex == 0 )
			{
				return( string.Format( "Server={0};Integrated Security=true", this.serverNameComboBox.Text ) );
			}
			else
			{
				return( string.Format( "Server={0};UID={1};PWD={2}",
										this.serverNameComboBox.Text,
										this.userNameTextBox.Text,
										this.passwordTextBox.Text ) );
			}
		}

		private void ConnectSqlClientDialog_Load( object sender, EventArgs e )
		{
			this.authenticationComboBox.Items.Add( "Windows 認証" );
			this.authenticationComboBox.Items.Add( "SQL Server 認証" );

			this.authenticationComboBox.SelectedIndex = 0;

			this.userNameLabel.Enabled = false;
			this.userNameTextBox.Enabled = false;
			this.passwordLabel.Enabled = false;
			this.passwordTextBox.Enabled = false;
		}

		private void authenticationComboBox_SelectedIndexChanged( object sender, EventArgs e )
		{
			bool isEnabled = ( this.authenticationComboBox.SelectedIndex == 0 ) ? false : true;

			this.userNameLabel.Enabled = isEnabled;
			this.userNameTextBox.Enabled = isEnabled;
			this.passwordLabel.Enabled = isEnabled;
			this.passwordTextBox.Enabled = isEnabled;
		}

		void databaseComboBox_MouseClick( object sender, System.Windows.Forms.MouseEventArgs e )
		{
			try
			{
				if( this.databaseComboBox.Items.Count == 0 )
				{
					List< DataRow > rows = new List< DataRow >();

					using( SqlConnection connection = new SqlConnection( this.CreateConnectionStringToServer() + ";Connect Timeout = 5" ) )
					{
						connection.Open();

						foreach( DataRow row in connection.GetSchema( SqlClientMetaDataCollectionNames.Databases ).Rows )//, new string[]{ null, "dbo", null, null } ).Rows )
						{
							rows.Add( row );
						}
					}

					rows.Sort( ( x, y ) => x[ "database_name" ].ToString().CompareTo( y[ "database_name" ].ToString() ) );

					foreach( DataRow row in rows )
					{
						this.databaseComboBox.Items.Add( row[ "database_name" ].ToString() );
					}
				}
			}
			catch
			{
			}
		}
	}
}
