/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.node.AbstractNode;
import org.seasar.framework.util.OgnlUtil;

public class ParenBindVariableNode
extends AbstractNode {
    private String expression;
    private Object parsedExpression;

    public ParenBindVariableNode(String expression) {
        this.expression = expression;
        this.parsedExpression = OgnlUtil.parseExpression((String)expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(SqlContext ctx) {
        Object var = OgnlUtil.getValue((Object)this.parsedExpression, (Object)ctx);
        if (var instanceof List) {
            this.bindArray(ctx, ((List)var).toArray());
        } else {
            if (var == null) {
                return;
            }
            if (var.getClass().isArray()) {
                this.bindArray(ctx, var);
            } else {
                ctx.addSql("?", var, var.getClass());
            }
        }
    }

    protected void bindArray(SqlContext ctx, Object array) {
        int i;
        int length = Array.getLength(array);
        if (length == 0) {
            return;
        }
        Class<?> clazz = null;
        for (i = 0; i < length; ++i) {
            Object o = Array.get(array, i);
            if (o == null) continue;
            clazz = o.getClass();
        }
        ctx.addSql("(");
        ctx.addSql("?", Array.get(array, 0), clazz);
        for (i = 1; i < length; ++i) {
            ctx.addSql(", ?", Array.get(array, i), clazz);
        }
        ctx.addSql(")");
    }
}

