/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.ValueType;

public class BinaryType
implements ValueType {
    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getBytes(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBytes(columnName);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -2);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            ps.setBinaryStream(index, (InputStream)in, ba.length);
        } else {
            ps.setObject(index, value);
        }
    }
}

