/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.util.StringUtil;

public class SqlTimestampConverter
extends AbstractConverter {
    public Object convert(Object source, Class destClass, ConversionContext context) {
        DateFormat dateFormat;
        if (source == null) {
            return null;
        }
        if (source instanceof Timestamp) {
            return source;
        }
        if (source instanceof Date) {
            return this.toTimestamp((Date)source);
        }
        if (source instanceof Calendar) {
            return this.toTimestamp((Calendar)source);
        }
        if (source instanceof Number) {
            return this.toTimestamp((Number)source);
        }
        if (source instanceof String && (dateFormat = (DateFormat)context.getContextInfo("TIMESTAMP_PATTERN")) != null) {
            return this.toTimestamp((String)source, dateFormat);
        }
        return null;
    }

    protected Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    protected Timestamp toTimestamp(Calendar calendar) {
        return this.toTimestamp(calendar.getTime());
    }

    protected Timestamp toTimestamp(Number date) {
        return new Timestamp(date.longValue());
    }

    protected Timestamp toTimestamp(String date, DateFormat dateFormat) {
        if (StringUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            return this.toTimestamp(dateFormat.parse(date));
        }
        catch (ParseException e) {
            return null;
        }
    }
}

