/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.annotation.impl;

import java.lang.reflect.Method;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;

public class ConstantAnnotationReader
implements AnnotationReader {
    public String getDatePattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "DATE_PATTERN");
    }

    public String getTimePattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "TIME_PATTERN");
    }

    public String getTimestampPattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "TIMESTAMP_PATTERN");
    }

    public String getDatePattern(Class dxoClass, Method method, String annotation) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, annotation))) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = method.getName() + "_" + annotation;
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = annotation;
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    public String getConversionRule(Class dxoClass, Method method) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, "CONVERSION_RULE"))) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = method.getName() + "_" + "CONVERSION_RULE";
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    protected String getConstantAnnotationName(Method method, String suffix) {
        StringBuffer buf = new StringBuffer(100).append(method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            buf.append("_").append(this.getShortClassName(parameterTypes[i]));
        }
        buf.append("_").append(suffix);
        return new String(buf);
    }

    protected String getShortClassName(Class clazz) {
        if (clazz.isArray()) {
            return ClassUtil.getShortClassName(clazz.getComponentType()) + "$";
        }
        return ClassUtil.getShortClassName((Class)clazz);
    }
}

