/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.types.BigDecimalType;
import org.seasar.extension.dataset.types.BinaryType;
import org.seasar.extension.dataset.types.BooleanType;
import org.seasar.extension.dataset.types.ObjectType;
import org.seasar.extension.dataset.types.StringType;
import org.seasar.extension.dataset.types.TimestampType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;

public class ColumnTypes {
    public static final ColumnType STRING = new StringType();
    public static final ColumnType BIGDECIMAL = new BigDecimalType();
    public static final ColumnType TIMESTAMP = new TimestampType();
    public static final ColumnType BINARY = new BinaryType();
    public static final ColumnType OBJECT = new ObjectType();
    public static final ColumnType BOOLEAN = new BooleanType();
    private static Map types_ = new HashMap();

    public static ValueType getValueType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValueTypes.BIGDECIMAL;
            }
            case 16: {
                return ValueTypes.BOOLEAN;
            }
            case 91: 
            case 92: 
            case 93: {
                return ValueTypes.TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: {
                return ValueTypes.BINARY;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueTypes.STRING;
            }
        }
        return ValueTypes.OBJECT;
    }

    public static ColumnType getColumnType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BIGDECIMAL;
            }
            case 16: {
                return BOOLEAN;
            }
            case 91: 
            case 92: 
            case 93: {
                return TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: {
                return BINARY;
            }
            case -1: 
            case 1: 
            case 12: {
                return STRING;
            }
        }
        return OBJECT;
    }

    public static ColumnType getColumnType(Object value) {
        if (value == null) {
            return OBJECT;
        }
        return ColumnTypes.getColumnType(value.getClass());
    }

    public static ColumnType getColumnType(Class clazz) {
        ColumnType columnType = ColumnTypes.getColumnType0(clazz);
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnType getColumnType0(Class clazz) {
        Map map = types_;
        synchronized (map) {
            return (ColumnType)types_.get(clazz);
        }
    }

    static {
        types_.put(String.class, STRING);
        types_.put(Short.TYPE, BIGDECIMAL);
        types_.put(Short.class, BIGDECIMAL);
        types_.put(Integer.TYPE, BIGDECIMAL);
        types_.put(Integer.class, BIGDECIMAL);
        types_.put(Long.TYPE, BIGDECIMAL);
        types_.put(Long.class, BIGDECIMAL);
        types_.put(Float.TYPE, BIGDECIMAL);
        types_.put(Float.class, BIGDECIMAL);
        types_.put(Double.TYPE, BIGDECIMAL);
        types_.put(Double.class, BIGDECIMAL);
        types_.put(Boolean.TYPE, BOOLEAN);
        types_.put(Boolean.class, BOOLEAN);
        types_.put(BigDecimal.class, BIGDECIMAL);
        types_.put(Timestamp.class, TIMESTAMP);
        types_.put(Date.class, TIMESTAMP);
        types_.put(java.util.Date.class, TIMESTAMP);
        types_.put(Calendar.class, TIMESTAMP);
        types_.put(new byte[0].getClass(), BINARY);
    }
}

