/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util.xml;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.seasar.mayaa.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.xml.TagHandler;
import org.seasar.mayaa.impl.util.xml.TagHandlerStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private TagHandlerStack _stack;
    private Log _log;
    private Locator _locator;
    private Map _entities;
    private Class _neighborClass;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$util$xml$XMLHandler;

    protected void setRootHandler(TagHandler rootHandler) {
        if (rootHandler == null) {
            throw new IllegalArgumentException();
        }
        this._stack = new TagHandlerStack(rootHandler);
    }

    protected void setLog(Log log) {
        this._log = log;
    }

    protected Log getLog() {
        return this._log;
    }

    protected void setNeighborClass(Class neighborClass) {
        if (neighborClass == null) {
            throw new IllegalArgumentException();
        }
        this._neighborClass = neighborClass;
    }

    protected Class getNeighborClass() {
        return this._neighborClass;
    }

    protected Map getEntityMap() {
        if (this._entities == null) {
            this._entities = new HashMap();
        }
        return this._entities;
    }

    protected String getSystemID() {
        if (this._locator != null) {
            return this._locator.getSystemId();
        }
        return null;
    }

    protected int getLineNumber() {
        if (this._locator != null) {
            return this._locator.getLineNumber();
        }
        return 0;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String path = systemId;
        Map entities = this.getEntityMap();
        if (entities != null && entities.containsKey(publicId)) {
            path = (String)entities.get(publicId);
        } else if (entities != null && entities.containsKey(systemId)) {
            path = (String)entities.get(systemId);
        } else {
            int pos = systemId.lastIndexOf(47);
            if (pos != -1) {
                path = systemId.substring(pos);
            }
        }
        Class<?> neighborClass = this.getNeighborClass();
        if (neighborClass == null) {
            neighborClass = this.getClass();
        }
        ClassLoaderSourceDescriptor source = new ClassLoaderSourceDescriptor();
        source.setSystemID(path);
        source.setNeighborClass(neighborClass);
        if (source.exists()) {
            InputSource ret = new InputSource(source.getInputStream());
            ret.setPublicId(publicId);
            ret.setSystemId(path);
            return ret;
        }
        Log log = this.getLog();
        if (log != null && log.isWarnEnabled()) {
            String message = StringUtil.getMessage(class$org$seasar$mayaa$impl$util$xml$XMLHandler == null ? (class$org$seasar$mayaa$impl$util$xml$XMLHandler = XMLHandler.class$("org.seasar.mayaa.impl.util.xml.XMLHandler")) : class$org$seasar$mayaa$impl$util$xml$XMLHandler, 0, publicId, systemId);
            log.warn((Object)message);
        }
        return null;
    }

    public void startDocument() {
        if (this._stack == null) {
            throw new IllegalStateException();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this._stack.startElement(localName, attributes, this.getSystemID(), this.getLineNumber());
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this._stack.endElement();
    }

    public void characters(char[] ch, int start, int length) {
        this._stack.characters(ch, start, length);
    }

    public void warning(SAXParseException e) {
        Log log = this.getLog();
        if (log != null && log.isWarnEnabled()) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void error(SAXParseException e) {
        Log log = this.getLog();
        if (log != null && log.isErrorEnabled()) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        throw new RuntimeException(e);
    }

    public void fatalError(SAXParseException e) {
        Log log = this.getLog();
        if (log != null && log.isFatalEnabled()) {
            log.fatal((Object)e.getMessage(), (Throwable)e);
        }
        throw new RuntimeException(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

