/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.impl.util.collection.EnumerationIterator;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class IteratorIterator
implements Iterator {
    private List _iterators = new ArrayList();
    private Iterator _iteratorIterator;
    private Iterator _currentIterator;

    protected void check(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (this._iteratorIterator != null) {
            throw new IllegalStateException();
        }
    }

    public void add(Collection collection) {
        this.check(collection);
        this._iterators.add(collection);
    }

    public void add(Enumeration enumeration) {
        this.check(enumeration);
        this._iterators.add(enumeration);
    }

    public void add(SourceScanner scanner) {
        this.check(scanner);
        this._iterators.add(scanner);
    }

    public void add(Iterator iterator) {
        this.check(iterator);
        this._iterators.add(iterator);
    }

    public void remove() {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.remove();
    }

    public boolean hasNext() {
        if (this._currentIterator == null || !this._currentIterator.hasNext()) {
            this._currentIterator = this.iteratorNext();
            if (this._currentIterator == NullIterator.getInstance()) {
                return false;
            }
            return this.hasNext();
        }
        return true;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._currentIterator.next();
    }

    public Iterator iteratorNext() {
        if (this._iteratorIterator == null) {
            this._iteratorIterator = this._iterators.iterator();
        }
        if (!this._iteratorIterator.hasNext()) {
            return NullIterator.getInstance();
        }
        Object o = this._iteratorIterator.next();
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Enumeration) {
            return EnumerationIterator.getInstance((Enumeration)o);
        }
        if (o instanceof SourceScanner) {
            return ((SourceScanner)o).scan();
        }
        return (Iterator)o;
    }
}

