/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.util.Date;
import java.util.Iterator;
import org.seasar.mayaa.impl.source.ClassLoaderSourceDescriptor;
import org.seasar.mayaa.impl.source.CompositeSourceDescriptor;
import org.seasar.mayaa.impl.source.SourceDescriptorObserver;
import org.seasar.mayaa.impl.source.SourceHolderFactory;
import org.seasar.mayaa.source.SourceDescriptor;
import org.seasar.mayaa.source.SourceHolder;

public class PageSourceDescriptor
extends CompositeSourceDescriptor
implements SourceDescriptorObserver {
    private static final long serialVersionUID = -6821253020265849514L;

    public boolean collectSourceDescriptor(SourceDescriptorObserver listener) throws Exception {
        Iterator it = SourceHolderFactory.iterator();
        while (it.hasNext()) {
            SourceHolder holder = (SourceHolder)it.next();
            if (listener.nextSourceDescriptor(holder.getSourceDescriptor(""))) continue;
            return false;
        }
        ClassLoaderSourceDescriptor loader = new ClassLoaderSourceDescriptor();
        loader.setRoot("/META-INF");
        loader.setTimestamp(new Date());
        return listener.nextSourceDescriptor(loader);
    }

    public boolean nextSourceDescriptor(SourceDescriptor sourceDescriptor) {
        sourceDescriptor.setSystemID(this.getSystemID());
        this.addSourceDescriptor(sourceDescriptor);
        return true;
    }

    public void setSystemID(String systemID) {
        super.setSystemID(systemID);
        try {
            this.collectSourceDescriptor(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setParameter(String name, String value) {
        super.setParameter(name, value);
    }
}

