/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.factory;

import org.seasar.mayaa.ParameterAware;
import org.seasar.mayaa.UnifiedFactory;
import org.seasar.mayaa.impl.MarshallUtil;
import org.seasar.mayaa.impl.provider.factory.AbstractParameterAwareTagHandler;
import org.seasar.mayaa.impl.util.XMLUtil;
import org.xml.sax.Attributes;

public class FactoryTagHandler
extends AbstractParameterAwareTagHandler {
    private Class _interfaceClass;
    private UnifiedFactory _beforeFactory;
    private UnifiedFactory _currentFactory;

    public FactoryTagHandler(Class interfaceClass, UnifiedFactory beforeFactory) {
        super("factory");
        if (interfaceClass == null) {
            throw new IllegalArgumentException();
        }
        this._interfaceClass = interfaceClass;
        this._beforeFactory = beforeFactory;
    }

    protected void start(Attributes attributes, String systemID, int lineNumber) {
        Class factoryClass = XMLUtil.getClassValue(attributes, "class", null);
        this._currentFactory = (UnifiedFactory)MarshallUtil.marshall(factoryClass, this._interfaceClass, this._beforeFactory, systemID, lineNumber);
        Class serviceClass = XMLUtil.getClassValue(attributes, "serviceClass", null);
        if (serviceClass != null) {
            this._currentFactory.setServiceClass(serviceClass);
        } else if (this._currentFactory.getServiceClass() == null) {
            throw new IllegalStateException();
        }
    }

    public UnifiedFactory getFactory() {
        if (this._currentFactory == null) {
            throw new IllegalStateException();
        }
        return this._currentFactory;
    }

    public ParameterAware getParameterAware() {
        return this.getFactory();
    }
}

