/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification.serialize;

import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.serialize.SerializeThread;

public class SerializeThreadManager {
    protected static SerializeThread[] _serializeThreads = new SerializeThread[10];
    private static volatile boolean _terminated;

    private SerializeThreadManager() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serializeReserve(SpecificationImpl spec, Object servletContext) {
        int fewIndex = -1;
        int min = Integer.MAX_VALUE;
        SerializeThread[] serializeThreadArray = _serializeThreads;
        synchronized (_serializeThreads) {
            if (_terminated) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            for (int i = 0; i < _serializeThreads.length; ++i) {
                int waitCount;
                if (_serializeThreads[i] == null) {
                    SerializeThreadManager._serializeThreads[i] = new SerializeThread(i, servletContext);
                    if (_serializeThreads[i].add(spec)) {
                        _serializeThreads[i].start();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return true;
                    }
                }
                if ((waitCount = _serializeThreads[i].waitCount()) >= min) continue;
                min = waitCount;
                fewIndex = i;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return _serializeThreads[fewIndex].add(spec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        _terminated = true;
        SerializeThread[] serializeThreadArray = _serializeThreads;
        synchronized (_serializeThreads) {
            for (int i = 0; i < _serializeThreads.length; ++i) {
                if (_serializeThreads[i] == null) continue;
                _serializeThreads[i].terminate();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            while (!SerializeThreadManager.isReleasedAll()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void threadDestroy(int index) {
        SerializeThread[] serializeThreadArray = _serializeThreads;
        synchronized (_serializeThreads) {
            SerializeThreadManager._serializeThreads[index] = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isReleasedAll() {
        SerializeThread[] serializeThreadArray = _serializeThreads;
        synchronized (_serializeThreads) {
            for (int i = 0; i < _serializeThreads.length; ++i) {
                if (_serializeThreads[i] == null) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }
}

