/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.engine.specification.CopyToFilter;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.NodeObject;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.engine.specification.NamespaceImpl;
import org.seasar.mayaa.impl.engine.specification.NodeAttributeImpl;
import org.seasar.mayaa.impl.engine.specification.NodeTreeWalkerImpl;
import org.seasar.mayaa.impl.engine.specification.PrefixAwareNameImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class SpecificationNodeImpl
extends NamespaceImpl
implements SpecificationNode,
CONST_IMPL {
    private static final long serialVersionUID = -6279723388151915362L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$specification$SpecificationNodeImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$SpecificationNodeImpl = SpecificationNodeImpl.class$("org.seasar.mayaa.impl.engine.specification.SpecificationNodeImpl")) : class$org$seasar$mayaa$impl$engine$specification$SpecificationNodeImpl));
    private static final CopyToFilter FILTER_ALL = new AllCopyToFilter();
    private int _sequenceID = -1;
    private Map _attributes;
    private NodeTreeWalkerImpl _delegateNodeTreeWalker;
    private QName _qName;
    private transient String _finalizeLabel;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$specification$SpecificationNodeImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl;

    public SpecificationNodeImpl(QName qName) {
        this._qName = qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeTreeWalker getNodeTreeWalker() {
        if (this._delegateNodeTreeWalker == null) {
            SpecificationNodeImpl specificationNodeImpl = this;
            synchronized (specificationNodeImpl) {
                this._delegateNodeTreeWalker = new NodeTreeWalkerImpl();
                this._delegateNodeTreeWalker.setOwner(this);
            }
        }
        return this._delegateNodeTreeWalker;
    }

    protected String makeReleasedLabel() {
        if (this._finalizeLabel == null) {
            try {
                this._finalizeLabel = this.toString();
            }
            catch (Throwable e) {
                this._finalizeLabel = this.getNodeTreeWalker().getSystemID() + " <" + this._qName + ">";
            }
        }
        if (this._finalizeLabel != null) {
            return "node " + this._finalizeLabel + "@" + this.hashCode() + " unloaded.";
        }
        return "";
    }

    public String toString() {
        StringBuffer path = new StringBuffer();
        if (this.getParentNode() != null && !(this.getParentNode() instanceof Specification)) {
            path.append(this.getParentNode());
        }
        path.append("/");
        path.append(PrefixAwareNameImpl.forPrefixAwareNameString(this.getQName(), this.getPrefix()));
        return path.toString();
    }

    protected void finalize() throws Throwable {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this.makeReleasedLabel());
        }
    }

    public QName getQName() {
        return this._qName;
    }

    public String getPrefix() {
        URI namespaceURI = this.getQName().getNamespaceURI();
        Iterator it = this.iteratePrefixMapping(true);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            if (!namespaceURI.equals(mapping.getNamespaceURI())) continue;
            return mapping.getPrefix();
        }
        return "";
    }

    public void setSequenceID(int sequenceID) {
        if (sequenceID < 0) {
            throw new IllegalArgumentException("sequenceID");
        }
        this._sequenceID = sequenceID;
    }

    public int getSequenceID() {
        if (this._sequenceID < 0) {
            LOG.info((Object)("already unloaded." + this.makeReleasedLabel()));
        }
        return this._sequenceID;
    }

    public void addAttribute(QName qName, String value) {
        this.addAttribute(qName, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(QName qName, String originalName, String value) {
        if (qName == null || value == null) {
            throw new IllegalArgumentException();
        }
        Object object = this;
        synchronized (object) {
            if (this._attributes == null) {
                this._attributes = new LinkedHashMap();
            }
        }
        object = this._attributes;
        synchronized (object) {
            if (!this._attributes.containsKey(qName)) {
                String prefix = null;
                if (originalName != null) {
                    prefix = StringUtil.parsePrefix(originalName);
                }
                NodeAttributeImpl attr = new NodeAttributeImpl(qName, value, prefix);
                this._attributes.put(qName, attr);
                attr.setNode(this);
            }
        }
    }

    public NodeAttribute getAttribute(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        if (this._attributes == null) {
            return null;
        }
        return (NodeAttribute)this._attributes.get(qName);
    }

    public Iterator iterateAttribute() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAttribute removeAttribute(QName qName) {
        if (this._attributes != null) {
            Map map = this._attributes;
            synchronized (map) {
                return (NodeAttribute)this._attributes.remove(qName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        if (this._attributes != null) {
            Map map = this._attributes;
            synchronized (map) {
                this._attributes.clear();
            }
        }
    }

    public SpecificationNode copyTo(CopyToFilter filter) {
        SpecificationNode copy = SpecificationUtil.createSpecificationNode(this.getQName(), this.getSystemID(), this.getLineNumber(), this.isOnTemplate(), this.getSequenceID());
        Iterator it = this.iterateAttribute();
        while (it.hasNext()) {
            NodeAttribute attr = (NodeAttribute)it.next();
            if (!filter.accept(attr)) continue;
            copy.addAttribute(attr.getQName(), attr.getValue());
        }
        it = this.iterateChildNode();
        while (it.hasNext()) {
            SpecificationNode node = (SpecificationNode)it.next();
            if (!filter.accept(node)) continue;
            copy.addChildNode(node.copyTo(filter));
        }
        it = this.iteratePrefixMapping(false);
        while (it.hasNext()) {
            PrefixMapping prefixMapping = (PrefixMapping)it.next();
            copy.addPrefixMapping(prefixMapping.getPrefix(), prefixMapping.getNamespaceURI());
        }
        copy.setParentSpace(SpecificationUtil.getFixedNamespace(this.getParentSpace()));
        copy.setDefaultNamespaceURI(this.getDefaultNamespaceURI());
        return copy;
    }

    public SpecificationNode copyTo() {
        return this.copyTo(FILTER_ALL);
    }

    public void setParentNode(NodeTreeWalker parent) {
        this.getNodeTreeWalker().setParentNode(parent);
    }

    public NodeTreeWalker getParentNode() {
        return this.getNodeTreeWalker().getParentNode();
    }

    public void addChildNode(NodeTreeWalker childNode) {
        this.getNodeTreeWalker().addChildNode(childNode);
    }

    public void insertChildNode(int index, NodeTreeWalker childNode) {
        this.getNodeTreeWalker().insertChildNode(index, childNode);
    }

    public Iterator iterateChildNode() {
        return this.getNodeTreeWalker().iterateChildNode();
    }

    public boolean removeChildNode(NodeTreeWalker node) {
        return this.getNodeTreeWalker().removeChildNode(node);
    }

    public NodeTreeWalker getChildNode(int index) {
        return this.getNodeTreeWalker().getChildNode(index);
    }

    public int getChildNodeSize() {
        return this.getNodeTreeWalker().getChildNodeSize();
    }

    public void kill() {
        if (LOG.isTraceEnabled()) {
            this.makeReleasedLabel();
        }
        this._sequenceID = -1;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.kill();
            this._delegateNodeTreeWalker = null;
        }
    }

    public void clearChildNodes() {
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.clearChildNodes();
        }
    }

    public void setSystemID(String systemID) {
        this.getNodeTreeWalker().setSystemID(systemID);
    }

    public String getSystemID() {
        return this.getNodeTreeWalker().getSystemID();
    }

    public void setLineNumber(int lineNumber) {
        this.getNodeTreeWalker().setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return this.getNodeTreeWalker().getLineNumber();
    }

    public void setOnTemplate(boolean onTemplate) {
        this.getNodeTreeWalker().setOnTemplate(onTemplate);
    }

    public boolean isOnTemplate() {
        return this.getNodeTreeWalker().isOnTemplate();
    }

    public NodeReferenceResolver findNodeResolver() {
        return this.getNodeTreeWalker().findNodeResolver();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(super.toString());
        if (this.getParentSpace() != null && this.getParentSpace().getClass() == (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = SpecificationNodeImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl)) {
            out.writeObject(this.getParentSpace());
        } else {
            out.writeObject(new Serializable(){
                private static final long serialVersionUID = 1L;
            });
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.setOwner(this);
        }
        String currentMappingInfo = in.readUTF();
        NamespaceImpl namespace = NamespaceImpl.deserialize(currentMappingInfo);
        this.setDefaultNamespaceMapping(namespace.getDefaultNamespaceMapping());
        Iterator it = namespace.iteratePrefixMapping(false);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            this.addPrefixMapping(mapping.getPrefix(), mapping.getNamespaceURI());
        }
        Object nscheck = in.readObject();
        if (nscheck instanceof NamespaceImpl) {
            this.setParentSpace((Namespace)nscheck);
        }
        this.findNodeResolver().nodeLoaded(this);
    }

    private Object readResolve() {
        Iterator it = this.iterateChildNode();
        while (it.hasNext()) {
            NodeTreeWalker child = (NodeTreeWalker)it.next();
            child.setParentNode(this);
            if (!(child instanceof Namespace)) continue;
            ((Namespace)((Object)child)).setParentSpace(this);
        }
        it = this.iterateAttribute();
        while (it.hasNext()) {
            NodeAttributeImpl attr = (NodeAttributeImpl)it.next();
            attr.setNode(this);
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class AllCopyToFilter
    implements CopyToFilter {
        protected AllCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            return true;
        }
    }
}

