/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.util.StringUtil;

public class QNameImpl
implements QName,
CONST_IMPL,
Serializable {
    private static final long serialVersionUID = -102674132611191747L;
    private static Map _cache = new ReferenceMap(0, 1, true);
    private URI _namespaceURI;
    private String _localName;

    public static QName getInstance(String localName) {
        return QNameImpl.getInstance(CONST_IMPL.URI_MAYAA, localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized QName getInstance(URI namespaceURI, String localName) {
        QName result;
        String key = QNameImpl.forQNameString(namespaceURI, localName);
        Map map = _cache;
        synchronized (map) {
            result = (QName)_cache.get(key);
            if (result == null) {
                result = new QNameImpl(namespaceURI, localName);
                _cache.put(key, result);
            }
        }
        return result;
    }

    private QNameImpl() {
    }

    private QNameImpl(URI namespaceURI, String localName) {
        if (StringUtil.isEmpty(namespaceURI) || StringUtil.isEmpty(localName)) {
            throw new IllegalArgumentException();
        }
        this._namespaceURI = namespaceURI;
        this._localName = localName;
    }

    public URI getNamespaceURI() {
        return this._namespaceURI;
    }

    public String getLocalName() {
        return this._localName;
    }

    private static String forQNameString(URI namespaceURI, String localName) {
        return "{" + namespaceURI + "}" + localName;
    }

    public String toString() {
        return QNameImpl.forQNameString(this.getNamespaceURI(), this.getLocalName());
    }

    public boolean equals(Object test) {
        if (test instanceof QName) {
            QName qName = (QName)test;
            return this.getNamespaceURI().equals(qName.getNamespaceURI()) && this.getLocalName().equalsIgnoreCase(qName.getLocalName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private Object readResolve() {
        return QNameImpl.getInstance(this._namespaceURI, this._localName);
    }
}

