/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class PrefixMappingImpl
implements PrefixMapping,
Serializable {
    private static final long serialVersionUID = -7627574345551562433L;
    private static Map _cache = new ReferenceMap(1, 1, true);
    private String _prefix;
    private URI _namespaceURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrefixMapping getInstance(String prefix, URI namespaceURI) {
        PrefixMapping result;
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        String key = PrefixMappingImpl.forPrefixMappingString(prefix, namespaceURI);
        Map map = _cache;
        synchronized (map) {
            result = (PrefixMapping)_cache.get(key);
            if (result == null) {
                result = new PrefixMappingImpl(prefix, namespaceURI);
                _cache.put(key, result);
            }
        }
        return result;
    }

    private PrefixMappingImpl(String prefix, URI namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            prefix = "";
        }
        this._prefix = prefix;
        this._namespaceURI = namespaceURI;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public URI getNamespaceURI() {
        return this._namespaceURI;
    }

    public static String forPrefixMappingString(String prefix, URI namespaceURI) {
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.hasValue(prefix)) {
            buffer.append(prefix);
        }
        buffer.append(":").append(namespaceURI);
        return buffer.toString();
    }

    public static PrefixMapping revertStringToMapping(String prefixMappingString) {
        String namespaceURI;
        String prefix;
        if (prefixMappingString == null) {
            return null;
        }
        int index = prefixMappingString.indexOf(58);
        if (index >= 0) {
            prefix = prefixMappingString.substring(0, index);
            namespaceURI = prefixMappingString.substring(index + 1);
        } else {
            if (String.valueOf((Object)null).equals(prefixMappingString)) {
                return null;
            }
            prefix = "";
            namespaceURI = prefixMappingString;
        }
        return PrefixMappingImpl.getInstance(prefix, SpecificationUtil.createURI(namespaceURI));
    }

    public String toString() {
        return PrefixMappingImpl.forPrefixMappingString(this.getPrefix(), this.getNamespaceURI());
    }

    public boolean equals(Object test) {
        if (test == null || !(test instanceof PrefixMapping)) {
            return false;
        }
        PrefixMappingImpl ns = (PrefixMappingImpl)test;
        return this.getPrefix().equals(ns.getPrefix()) && this.getNamespaceURI().equals(ns.getNamespaceURI());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static int keptSize() {
        return _cache.size();
    }

    private Object readResolve() {
        return PrefixMappingImpl.getInstance(this._prefix, this._namespaceURI);
    }
}

