/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.ReferenceCache;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class NamespaceImpl
implements Namespace {
    private static final long serialVersionUID = -3738362040016319461L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = NamespaceImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl));
    private static ReferenceCache _cache = new ReferenceCache(class$org$seasar$mayaa$engine$specification$Namespace == null ? (class$org$seasar$mayaa$engine$specification$Namespace = NamespaceImpl.class$("org.seasar.mayaa.engine.specification.Namespace")) : class$org$seasar$mayaa$engine$specification$Namespace);
    private transient Namespace _parentSpace;
    private transient Set _mappings;
    private transient PrefixMapping _defaultNamespaceMapping;
    private String _serializeKey;
    private transient boolean _needDeserialize;
    protected static Comparator _prefixMappingComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof PrefixMapping && o2 instanceof PrefixMapping) {
                PrefixMapping mapping1 = (PrefixMapping)o1;
                PrefixMapping mapping2 = (PrefixMapping)o2;
                URI ns1 = mapping1.getNamespaceURI();
                URI ns2 = mapping2.getNamespaceURI();
                int result = 0;
                if (ns1 == null) {
                    if (ns2 != null) {
                        result = -1;
                    }
                } else {
                    result = ns2 == null ? 1 : ns1.compareTo(ns2);
                }
                if (result == 0) {
                    String prefix1 = mapping1.getPrefix();
                    String prefix2 = mapping2.getPrefix();
                    if (prefix1 == null) {
                        prefix1 = "";
                    }
                    if (prefix2 == null) {
                        prefix2 = "";
                    }
                    result = prefix1.compareTo(prefix2);
                }
                return result;
            }
            throw new IllegalStateException();
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$specification$Namespace;

    public static Namespace getInstance(Namespace namespace) {
        return NamespaceImpl.getInstance(NamespaceImpl.serialize(namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace getInstance(String serializeKey) {
        ReferenceCache referenceCache = _cache;
        synchronized (referenceCache) {
            Iterator it = _cache.iterator();
            while (it.hasNext()) {
                NamespaceImpl space = (NamespaceImpl)it.next();
                if (!space.getSerializeKey().equals(serializeKey)) continue;
                return space;
            }
            NamespaceImpl namespace = NamespaceImpl.deserialize(serializeKey);
            if (!_cache.contains(namespace)) {
                _cache.add(namespace);
            }
            return namespace;
        }
    }

    public static Namespace copyOf(Namespace namespace) {
        if (namespace == null) {
            return namespace;
        }
        Namespace parent = namespace.getParentSpace();
        if (parent != null) {
            String key = NamespaceImpl.serialize(parent);
            parent = NamespaceImpl.getInstance(key);
        }
        NamespaceImpl result = new NamespaceImpl();
        result.setParentSpace(parent);
        Iterator it = namespace.iteratePrefixMapping(false);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            result.addPrefixMapping(mapping.getPrefix(), mapping.getNamespaceURI());
        }
        result.setDefaultNamespaceURI(namespace.getDefaultNamespaceURI());
        if (namespace instanceof NamespaceImpl) {
            result._serializeKey = ((NamespaceImpl)namespace)._serializeKey;
        }
        return result;
    }

    public void setParentSpace(Namespace parent) {
        if (parent != null && (this._parentSpace == parent || parent.equals(this._parentSpace))) {
            return;
        }
        this._parentSpace = parent;
        this._serializeKey = null;
    }

    public Namespace getParentSpace() {
        this.doDeserialize();
        return this._parentSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrefixMapping(String prefix, URI namespaceURI) {
        if (prefix == null || StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        NamespaceImpl namespaceImpl = this;
        synchronized (namespaceImpl) {
            PrefixMapping mapping;
            this.doDeserialize();
            if (this._mappings == null) {
                this._mappings = new TreeSet(_prefixMappingComparator);
            }
            if (!this._mappings.contains(mapping = SpecificationUtil.createPrefixMapping(prefix, namespaceURI))) {
                this._mappings.add(mapping);
                this._serializeKey = null;
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = NamespaceImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl, 0, mapping.toString()));
            }
        }
    }

    public void setDefaultNamespaceURI(URI namespaceURI) {
        this.doDeserialize();
        if (namespaceURI == null) {
            if (this._defaultNamespaceMapping != null) {
                this._defaultNamespaceMapping = null;
                this._serializeKey = null;
            }
            return;
        }
        Iterator it = this.iteratePrefixMapping(true);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            if (!mapping.getNamespaceURI().equals(namespaceURI)) continue;
            if (!mapping.equals(this._defaultNamespaceMapping)) {
                this._defaultNamespaceMapping = mapping;
                this._serializeKey = null;
            }
            return;
        }
        if (namespaceURI.equals(CONST_IMPL.URI_HTML)) {
            if (!SpecificationUtil.HTML_DEFAULT_PREFIX_MAPPING.equals(this._defaultNamespaceMapping)) {
                this._defaultNamespaceMapping = SpecificationUtil.HTML_DEFAULT_PREFIX_MAPPING;
                this._serializeKey = null;
            }
            return;
        }
        if (namespaceURI.equals(CONST_IMPL.URI_XHTML)) {
            this._defaultNamespaceMapping = SpecificationUtil.createPrefixMapping("", CONST_IMPL.URI_XHTML);
            this._serializeKey = null;
            return;
        }
        this._defaultNamespaceMapping = SpecificationUtil.createPrefixMapping("", namespaceURI);
        this._serializeKey = null;
    }

    protected void setDefaultNamespaceMapping(PrefixMapping defaultNamespaceMapping) {
        this._defaultNamespaceMapping = defaultNamespaceMapping;
    }

    protected PrefixMapping getDefaultNamespaceMapping() {
        this.doDeserialize();
        return this._defaultNamespaceMapping;
    }

    public URI getDefaultNamespaceURI() {
        this.doDeserialize();
        if (this._defaultNamespaceMapping == null) {
            return null;
        }
        return this._defaultNamespaceMapping.getNamespaceURI();
    }

    protected PrefixMapping getMapping(boolean fromPrefix, String test, boolean all) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        this.doDeserialize();
        if (this._defaultNamespaceMapping != null && (fromPrefix ? "".equals(test) || this._defaultNamespaceMapping.getPrefix().equals(test) : this._defaultNamespaceMapping.getNamespaceURI().equals(test))) {
            return this._defaultNamespaceMapping;
        }
        Iterator it = this.iteratePrefixMapping(all);
        while (it.hasNext()) {
            PrefixMapping mapping = (PrefixMapping)it.next();
            String value = fromPrefix ? mapping.getPrefix() : mapping.getNamespaceURI().getValue();
            if (!test.equals(value)) continue;
            return mapping;
        }
        if (CONST_IMPL.URI_XML.equals(test)) {
            return SpecificationUtil.XML_DEFAULT_PREFIX_MAPPING;
        }
        return null;
    }

    public PrefixMapping getMappingFromPrefix(String prefix, boolean all) {
        if (prefix == null) {
            prefix = "";
        }
        return this.getMapping(true, prefix, all);
    }

    public PrefixMapping getMappingFromURI(URI namespaceURI, boolean all) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        return this.getMapping(false, namespaceURI.getValue(), all);
    }

    public Iterator iteratePrefixMapping(boolean all) {
        if (all && this.getParentSpace() != null) {
            return new AllNamespaceIterator(this);
        }
        this.doDeserialize();
        if (this._mappings != null) {
            return this._mappings.iterator();
        }
        return NullIterator.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addedMapping() {
        this.doDeserialize();
        if (this._mappings == null) {
            return false;
        }
        Set set = this._mappings;
        synchronized (set) {
            return this._mappings.size() > 0;
        }
    }

    protected String getSerializeKey() {
        this.doDeserialize();
        NamespaceImpl.serialize(this);
        return this._serializeKey;
    }

    protected static String serialize(Namespace instance) {
        String result;
        if (!(instance instanceof NamespaceImpl)) {
            throw new IllegalStateException();
        }
        NamespaceImpl impl = (NamespaceImpl)instance;
        if (impl._serializeKey != null) {
            return impl._serializeKey;
        }
        ArrayList<Namespace> spaces = new ArrayList<Namespace>();
        for (Namespace parent = instance.getParentSpace(); parent != null; parent = parent.getParentSpace()) {
            spaces.add(parent);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = spaces.size() - 1; i >= 0; --i) {
            Namespace current = (Namespace)spaces.get(i);
            if (!(current instanceof NamespaceImpl)) {
                throw new IllegalStateException();
            }
            NamespaceImpl currentImpl = (NamespaceImpl)current;
            buffer.append(currentImpl.namespaceToString());
        }
        buffer.append(impl.namespaceToString());
        impl._serializeKey = result = buffer.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamespaceImpl deserialize(String serializeData) {
        String[] lines = serializeData.split("\n");
        NamespaceImpl parent = null;
        NamespaceImpl current = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.startsWith("/")) {
                line = line.substring("/".length());
                if (current != null) {
                    ReferenceCache referenceCache = _cache;
                    synchronized (referenceCache) {
                        if (!_cache.contains(current)) {
                            _cache.add(current);
                        }
                    }
                    parent = current;
                }
                current = new NamespaceImpl();
                if (!String.valueOf((Object)null).equals(line)) {
                    current._defaultNamespaceMapping = SpecificationUtil.createPrefixMapping(line);
                }
                if (parent == null) continue;
                current.setParentSpace(parent);
                continue;
            }
            if (!line.startsWith("\t") || current == null) continue;
            line = line.substring("\t".length());
            if (current._mappings == null) {
                current._mappings = new TreeSet(_prefixMappingComparator);
            }
            current._mappings.add(SpecificationUtil.createPrefixMapping(line));
        }
        return current;
    }

    private String namespaceToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/").append(this._defaultNamespaceMapping).append("\n");
        Iterator it = this.iteratePrefixMapping(false);
        while (it.hasNext()) {
            sb.append("\t").append(it.next()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.namespaceToString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = NamespaceImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl)) {
            NamespaceImpl other = (NamespaceImpl)obj;
            String otherKey = other.getSerializeKey();
            return this.getSerializeKey().equals(otherKey);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getClass() == (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = NamespaceImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl)) {
            this.getSerializeKey();
            out.defaultWriteObject();
        }
    }

    protected void doDeserialize() {
        if (this._needDeserialize) {
            this._needDeserialize = false;
            NamespaceImpl current = NamespaceImpl.deserialize(this.getSerializeKey());
            this._parentSpace = current._parentSpace;
            this._defaultNamespaceMapping = current._defaultNamespaceMapping;
            this._mappings = new TreeSet(_prefixMappingComparator);
            Iterator it = current.iteratePrefixMapping(false);
            while (it.hasNext()) {
                this._mappings.add(it.next());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.getClass() == (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl = NamespaceImpl.class$("org.seasar.mayaa.impl.engine.specification.NamespaceImpl")) : class$org$seasar$mayaa$impl$engine$specification$NamespaceImpl)) {
            in.defaultReadObject();
            this._needDeserialize = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class AllNamespaceIterator
    implements Iterator {
        private Namespace _current;
        private Iterator _it;

        public AllNamespaceIterator(Namespace current) {
            if (current == null) {
                throw new IllegalArgumentException();
            }
            this._current = current;
            this._it = current.iteratePrefixMapping(false);
        }

        public boolean hasNext() {
            while (this._it != null) {
                boolean ret = this._it.hasNext();
                if (ret) {
                    return true;
                }
                this._current = this._current.getParentSpace();
                if (this._current != null) {
                    this._it = this._current.iteratePrefixMapping(false);
                    continue;
                }
                this._it = null;
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                return this._it.next();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

