/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.OptimizableProcessor;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.NodeResolveListener;
import org.seasar.mayaa.engine.specification.serialize.ProcessorReferenceResolver;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.engine.TemplateImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.serialize.NodeSerializeController;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;

public class TemplateProcessorSupport
implements TemplateProcessor,
OptimizableProcessor {
    private static final long serialVersionUID = -3521980479718620027L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$processor$TemplateProcessorSupport == null ? (class$org$seasar$mayaa$impl$engine$processor$TemplateProcessorSupport = TemplateProcessorSupport.class$("org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport")) : class$org$seasar$mayaa$impl$engine$processor$TemplateProcessorSupport));
    private static final String PREFIX_UNIQUE_ID = "_m";
    private transient ProcessorTreeWalker _parent;
    private List _children;
    protected SpecificationNode _originalNode;
    protected transient SpecificationNode _injectedNode;
    private boolean _evalBodyInclude = true;
    private transient ProcessorDefinition _definition;
    private static final String DUPLICATE_ROOT_MARK = "<<root>>";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$TemplateProcessorSupport;

    public void initialize() {
    }

    public String getUniqueID() {
        int sequenceID = this.getOriginalNode().getSequenceID();
        return PREFIX_UNIQUE_ID + sequenceID;
    }

    public void setEvalBodyInclude(boolean evalBodyInclude) {
        this._evalBodyInclude = evalBodyInclude;
    }

    public boolean isEvalBodyInclude() {
        return this._evalBodyInclude;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._evalBodyInclude) {
            return ProcessStatus.EVAL_BODY_INCLUDE;
        }
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessStatus doEndProcess() {
        return ProcessStatus.EVAL_PAGE;
    }

    public void setOriginalNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException("originalNode must not be null");
        }
        this._originalNode = node;
    }

    public SpecificationNode getOriginalNode() {
        if (this._originalNode == null) {
            throw new IllegalStateException("originalNode is null");
        }
        return this._originalNode;
    }

    public void setInjectedNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException("injectedNode must not be null");
        }
        this._injectedNode = node;
    }

    public SpecificationNode getInjectedNode() {
        if (this._injectedNode == null) {
            throw new IllegalStateException("injectedNode is null");
        }
        return this._injectedNode;
    }

    public void setProcessorDefinition(ProcessorDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("processorDefinition must not be null");
        }
        this._definition = definition;
    }

    public ProcessorDefinition getProcessorDefinition() {
        if (this._definition == null) {
            throw new IllegalStateException("processorDefinition is null");
        }
        return this._definition;
    }

    protected boolean isHTML(QName qName) {
        URI namespaceURI = qName.getNamespaceURI();
        return CONST_IMPL.URI_HTML.equals(namespaceURI);
    }

    protected boolean isXHTML(QName qName) {
        URI namespaceURI = qName.getNamespaceURI();
        return CONST_IMPL.URI_XHTML.equals(namespaceURI);
    }

    public Map getVariables() {
        return null;
    }

    public void setParentProcessor(ProcessorTreeWalker parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parentProcessor must not be null");
        }
        this._parent = parent;
    }

    public ProcessorTreeWalker getParentProcessor() {
        return this._parent;
    }

    public void addChildProcessor(ProcessorTreeWalker child) {
        this.insertProcessor(Integer.MAX_VALUE, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertProcessor(int index, ProcessorTreeWalker child) {
        if (child == null) {
            throw new IllegalArgumentException("child is null");
        }
        Object object = this;
        synchronized (object) {
            if (this._children == null) {
                this._children = new ArrayList();
            }
        }
        object = this._children;
        synchronized (object) {
            if (index == Integer.MAX_VALUE) {
                index = this._children.size();
            }
            this._children.add(index, child);
            child.setParentProcessor(this);
            ++index;
            while (index < this._children.size()) {
                child = (ProcessorTreeWalker)this._children.get(index);
                child.setParentProcessor(this);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildProcessorSize() {
        if (this._children == null) {
            return 0;
        }
        List list = this._children;
        synchronized (list) {
            return this._children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorTreeWalker getChildProcessor(int index) {
        if (index < 0 || index >= this.getChildProcessorSize()) {
            throw new IndexOutOfBoundsException();
        }
        List list = this._children;
        synchronized (list) {
            return (ProcessorTreeWalker)this._children.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProcessor(ProcessorTreeWalker child) {
        if (this._children != null) {
            List list = this._children;
            synchronized (list) {
                return this._children.remove(child);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildProcessors() {
        if (this._children != null) {
            try {
                TemplateProcessorSupport templateProcessorSupport = this;
                synchronized (templateProcessorSupport) {
                    this._children.clear();
                }
            }
            finally {
                this._children = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        TemplateProcessorSupport templateProcessorSupport = this;
        synchronized (templateProcessorSupport) {
            this._originalNode = null;
            this._injectedNode = null;
            this._parent = null;
            if (this._children != null) {
                List list = this._children;
                synchronized (list) {
                    Iterator it = this._children.iterator();
                    while (it.hasNext()) {
                        TemplateProcessor processor = (TemplateProcessor)it.next();
                        processor.kill();
                    }
                }
            }
            this.clearChildProcessors();
        }
    }

    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        return new ProcessorTreeWalker[]{this};
    }

    public void notifyBeginRender(Page topLevelPage) {
    }

    protected void finalize() throws Throwable {
        if (LOG.isTraceEnabled()) {
            String name = ObjectUtil.getSimpleClassName(this.getClass());
            if (this._definition != null) {
                LOG.trace((Object)(name + " " + this.getProcessorDefinition().getName() + " unloaded."));
            } else {
                LOG.trace((Object)(name + " " + " unloaded."));
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String originalNodeID = NodeSerializeController.makeKey(this._originalNode);
        String uniqueID = this.getUniqueID();
        out.writeUTF(originalNodeID);
        out.writeUTF(uniqueID);
        out.writeObject(this._injectedNode.getQName());
        if (this._injectedNode.getParentNode() != null) {
            String injectedNodeID = NodeSerializeController.makeKey(this._injectedNode);
            out.writeUTF(injectedNodeID);
        } else {
            out.writeUTF(DUPLICATE_ROOT_MARK);
            out.writeObject(this._injectedNode);
        }
    }

    protected void nodeLoadAfter() {
        Namespace parentSpace;
        if (this._originalNode != null && this._injectedNode != null && (parentSpace = this.getOriginalNode().getParentSpace()) != null && this.getInjectedNode().getParentSpace() == null) {
            this.getInjectedNode().setParentSpace(parentSpace);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String originalNodeID = in.readUTF();
        String processorUniqueID = in.readUTF();
        QName qName = (QName)in.readObject();
        LibraryManager libraryManager = ProviderUtil.getLibraryManager();
        this.setProcessorDefinition(libraryManager.getProcessorDefinition(qName));
        String injectedNodeID = in.readUTF();
        NodeResolveListener listener = new TemplateProcessorSupportOriginalNodeListener(this);
        this.findNodeResolver().registResolveNodeListener(originalNodeID, listener);
        if (DUPLICATE_ROOT_MARK.equals(injectedNodeID)) {
            this._injectedNode = (SpecificationNode)in.readObject();
        } else {
            listener = new TemplateProcessorSupportInjectedNodeListener(this);
            this.findNodeResolver().registResolveNodeListener(injectedNodeID, listener);
        }
        ProcessorReferenceResolver resolver = this.findProcessorResolver();
        resolver.processorLoaded(processorUniqueID, this);
        if (this._children != null) {
            for (int i = this._children.size() - 1; i >= 0; --i) {
                ProcessorTreeWalker child = (ProcessorTreeWalker)this._children.get(i);
                child.setParentProcessor(this);
            }
        }
        LOG.debug((Object)"templateProcessorSupport loaded");
    }

    public ProcessorReferenceResolver findProcessorResolver() {
        return TemplateImpl.processorSerializer();
    }

    public NodeReferenceResolver findNodeResolver() {
        return SpecificationImpl.nodeSerializer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TemplateProcessorSupportInjectedNodeListener
    implements NodeResolveListener {
        private TemplateProcessorSupport _target;

        public TemplateProcessorSupportInjectedNodeListener(TemplateProcessorSupport target) {
            this._target = target;
        }

        public void notify(String uniqueID, NodeTreeWalker loadedInstance) {
            if (loadedInstance instanceof SpecificationNode) {
                SpecificationNode specNode;
                this._target._injectedNode = specNode = (SpecificationNode)loadedInstance;
                this._target.nodeLoadAfter();
            }
        }

        public void release() {
            this._target = null;
        }
    }

    private static class TemplateProcessorSupportOriginalNodeListener
    implements NodeResolveListener {
        private TemplateProcessorSupport _target;

        public TemplateProcessorSupportOriginalNodeListener(TemplateProcessorSupport target) {
            this._target = target;
        }

        public void notify(String uniqueID, NodeTreeWalker loadedInstance) {
            if (loadedInstance instanceof SpecificationNode) {
                SpecificationNode specNode;
                this._target._originalNode = specNode = (SpecificationNode)loadedInstance;
                this._target.nodeLoadAfter();
            }
        }

        public void release() {
            this._target = null;
        }
    }
}

