/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.cyberneko.html.HTMLElements;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.processor.AbstractAttributableProcessor;
import org.seasar.mayaa.impl.engine.processor.CharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.JspProcessor;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class ElementProcessor
extends AbstractAttributableProcessor
implements CONST_IMPL {
    private static final long serialVersionUID = 923306412062075314L;
    private static final String SUFFIX_DUPLICATED = "_d";
    private static final Set XHTML_EMPTY_ELEMENTS;
    private static final String RENDERED_NS_STACK_KEY;
    private static final String CURRENT_NS_KEY;
    private PrefixAwareName _name;
    private boolean _duplicated;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$ElementProcessor;
    static /* synthetic */ Class class$java$lang$String;

    protected void clearCurrentNS() {
        CycleUtil.clearGlobalVariable(CURRENT_NS_KEY);
    }

    protected Namespace getCurrentNS() {
        return (Namespace)CycleUtil.getGlobalVariable(CURRENT_NS_KEY, new Object[]{this.getOriginalNode()});
    }

    public void notifyBeginRender(Page topLevelPage) {
        CycleUtil.clearGlobalVariable(RENDERED_NS_STACK_KEY);
    }

    protected Stack getRenderedNS() {
        return (Stack)CycleUtil.getGlobalVariable(RENDERED_NS_STACK_KEY, null);
    }

    protected void addRendered(PrefixMapping mapping) {
        ((List)this.getRenderedNS().peek()).add(mapping);
    }

    protected String alreadyRenderedPrefix(URI namespaceURI) {
        Iterator iteratorRendered = ((AbstractList)this.getRenderedNS()).iterator();
        while (iteratorRendered.hasNext()) {
            Iterator mappings = ((List)iteratorRendered.next()).iterator();
            while (mappings.hasNext()) {
                PrefixMapping mapping = (PrefixMapping)mappings.next();
                if (!mapping.getNamespaceURI().equals(namespaceURI)) continue;
                return mapping.getPrefix();
            }
        }
        return null;
    }

    public void setDuplicated(boolean duplicated) {
        this._duplicated = duplicated;
    }

    public boolean isDuplicated() {
        return this._duplicated;
    }

    public void setName(PrefixAwareName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    protected PrefixAwareName getName() {
        if (this._name == null) {
            throw new IllegalStateException();
        }
        return this._name;
    }

    public String getUniqueID() {
        String uniqueID = super.getUniqueID();
        if (this.isDuplicated()) {
            uniqueID = uniqueID + SUFFIX_DUPLICATED;
        }
        return uniqueID;
    }

    public Class getExpectedClass() {
        return class$java$lang$String == null ? (class$java$lang$String = ElementProcessor.class$("java.lang.String")) : class$java$lang$String;
    }

    protected void resolvePrefix(PrefixAwareName name, Namespace currentNS) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        URI namespaceURI = name.getQName().getNamespaceURI();
        PrefixMapping mapping = currentNS.getMappingFromURI(namespaceURI, true);
        if (mapping != null) {
            return;
        }
        Namespace namespace = this.getInjectedNode().getParentSpace();
        mapping = namespace.getMappingFromURI(namespaceURI, true);
        if (mapping != null) {
            currentNS.addPrefixMapping(mapping.getPrefix(), mapping.getNamespaceURI());
            return;
        }
        currentNS.addPrefixMapping(name.getPrefix(), namespaceURI);
    }

    protected void resolvePrefixAll() {
        ProcessorProperty prop;
        Namespace currentNS = this.getCurrentNS();
        if (!CycleUtil.isDraftWriting()) {
            currentNS = SpecificationUtil.copyNamespace(currentNS);
        }
        this.resolvePrefix(this.getName(), currentNS);
        Iterator it = this.iterateProcesstimeProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.resolvePrefix(prop.getName(), currentNS);
        }
        it = this.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.resolvePrefix(prop.getName(), currentNS);
        }
    }

    protected String getResolvedPrefix(PrefixAwareName name) {
        URI namespaceURI;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (CONST_IMPL.URI_MAYAA.equals(name.getQName().getNamespaceURI())) {
            return "";
        }
        String prefix = this.alreadyRenderedPrefix(name.getQName().getNamespaceURI());
        if (prefix != null) {
            return prefix;
        }
        Namespace currentNS = this.getCurrentNS();
        PrefixMapping mapping = currentNS.getMappingFromURI(namespaceURI = name.getQName().getNamespaceURI(), true);
        if (mapping != null) {
            return mapping.getPrefix();
        }
        currentNS.addPrefixMapping("", namespaceURI);
        return "";
    }

    protected boolean appendPrefixMappingString(StringBuffer buffer, PrefixMapping mapping) {
        String pre = mapping.getPrefix();
        URI uri = mapping.getNamespaceURI();
        if (CONST_IMPL.URI_MAYAA.equals(uri)) {
            return false;
        }
        if (CONST_IMPL.URI_XML.equals(uri) && pre.equals("xml")) {
            return false;
        }
        if (StringUtil.hasValue(pre)) {
            buffer.append(" xmlns:").append(pre);
        } else {
            buffer.append(" xmlns");
        }
        buffer.append("=\"").append(uri).append('\"');
        this.addRendered(mapping);
        return true;
    }

    protected void appendPrefixMappingStrings(StringBuffer buffer, Namespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = namespace.iteratePrefixMapping(false);
        while (it.hasNext()) {
            this.appendPrefixMappingString(buffer, (PrefixMapping)it.next());
        }
    }

    protected void appendAttributeString(StringBuffer buffer, PrefixAwareName propName, Object value) {
        JspProcessor processor;
        URI injectNS;
        QName qName = propName.getQName();
        if (CONST_IMPL.URI_MAYAA.equals(qName.getNamespaceURI())) {
            return;
        }
        if (this.getInjectedNode().getQName().equals(CONST_IMPL.QM_DUPLECATED) && this.getChildProcessorSize() > 0 && this.getChildProcessor(0) instanceof JspProcessor && (injectNS = (processor = (JspProcessor)this.getChildProcessor(0)).getInjectedNode().getQName().getNamespaceURI()) == qName.getNamespaceURI()) {
            return;
        }
        String attrPrefix = propName.getPrefix();
        if (StringUtil.hasValue(attrPrefix) && StringUtil.hasValue(attrPrefix = this.getResolvedPrefix(propName))) {
            attrPrefix = attrPrefix + ":";
        }
        StringBuffer temp = new StringBuffer();
        temp.append(" ");
        temp.append(attrPrefix);
        temp.append(qName.getLocalName());
        temp.append("=\"");
        if (value instanceof CompiledScript) {
            CompiledScript script = (CompiledScript)value;
            if (CycleUtil.isDraftWriting()) {
                temp.append(script.getScriptText());
            } else {
                Object result = script.execute(null);
                if (result == null) {
                    return;
                }
                temp.append(result);
            }
        } else {
            temp.append(value.toString());
        }
        temp.append("\"");
        buffer.append(temp.toString());
    }

    protected boolean needsCloseElement(QName qName) {
        if (this.isHTML(qName)) {
            HTMLElements.Element element = HTMLElements.getElement((String)qName.getLocalName());
            return !element.isEmpty();
        }
        return this.getChildProcessorSize() > 0;
    }

    protected void write(String value) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(value);
    }

    protected void writeElementName(StringBuffer buffer) {
        QName qName = this.getName().getQName();
        String prefix = this.getResolvedPrefix(this.getName());
        if (StringUtil.hasValue(prefix)) {
            buffer.append(prefix).append(":");
        }
        buffer.append(qName.getLocalName());
    }

    protected void writePart1(StringBuffer buffer) {
        buffer.append("<");
        this.writeElementName(buffer);
    }

    protected void writePart2(StringBuffer buffer) {
        ProcessorProperty prop;
        Iterator it = this.iterateProcesstimeProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            this.internalWritePart2(buffer, prop);
        }
        it = this.iterateInformalProperties();
        while (it.hasNext()) {
            prop = (ProcessorProperty)it.next();
            if (this.hasProcesstimeProperty(prop) || prop.getValue().isLiteral()) continue;
            this.internalWritePart2(buffer, prop);
        }
    }

    protected void internalWritePart2(StringBuffer buffer, ProcessorProperty prop) {
        PrefixAwareName propName = prop.getName();
        if (this.isDuplicated()) {
            QName propQName = propName.getQName();
            URI propURI = propQName.getNamespaceURI();
            String propLocalName = propQName.getLocalName();
            if (this.getName().getQName().getNamespaceURI().equals(propURI) && "id".equals(propLocalName)) {
                return;
            }
        }
        this.appendAttributeString(buffer, propName, prop.getValue());
    }

    protected void writePart3(StringBuffer buffer) {
        Iterator it = this.iterateInformalProperties();
        while (it.hasNext()) {
            ProcessorProperty prop = (ProcessorProperty)it.next();
            if (this.hasProcesstimeProperty(prop) || !prop.getValue().isLiteral()) continue;
            this.appendAttributeString(buffer, prop.getName(), prop.getValue());
        }
        QName qName = this.getName().getQName();
        if (this.isHTML(qName) || this.getChildProcessorSize() > 0) {
            buffer.append(">");
        } else if (this.isXHTML(qName) && XHTML_EMPTY_ELEMENTS.contains(qName.getLocalName())) {
            buffer.append("/>");
        } else {
            buffer.append("></");
            this.writeElementName(buffer);
            buffer.append(">");
        }
    }

    protected void writePart4(StringBuffer buffer) {
        QName qName = this.getName().getQName();
        if (this.needsCloseElement(qName)) {
            buffer.append("</");
            this.writeElementName(buffer);
            buffer.append(">");
        }
    }

    protected ProcessStatus writeStartElement() {
        if (this.getName() == null) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = new StringBuffer();
        this.writePart1(buffer);
        this.appendPrefixMappingStrings(buffer, this.getCurrentNS());
        this.writePart2(buffer);
        this.writePart3(buffer);
        this.write(buffer.toString());
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    protected void writeBody(String body) {
        this.write(body);
    }

    protected void writeEndElement() {
        if (this.getName() == null) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = new StringBuffer();
        this.writePart4(buffer);
        this.write(buffer.toString());
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (topLevelPage != null) {
            topLevelPage.registBeginRenderNotifier(this);
        }
        this.renderInit();
        return super.doStartProcess(topLevelPage);
    }

    public ProcessStatus doEndProcess() {
        this.renderExit();
        return super.doEndProcess();
    }

    protected void renderInit() {
        this.clearCurrentNS();
        this.getRenderedNS().push(new ArrayList());
        this.resolvePrefixAll();
    }

    protected void renderExit() {
        this.getRenderedNS().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        this.renderInit();
        try {
            CharactersProcessor part2;
            ProcessorProperty prop;
            if (!this.getInjectedNode().getQName().equals(CONST_IMPL.QM_TEMPLATE_ELEMENT)) {
                ProcessorTreeWalker[] processorTreeWalkerArray = new ProcessorTreeWalker[]{this};
                return processorTreeWalkerArray;
            }
            StringBuffer xmlnsDefs = new StringBuffer();
            this.appendPrefixMappingStrings(xmlnsDefs, this.getCurrentNS());
            if (xmlnsDefs.length() > 0) {
                ProcessorTreeWalker[] processorTreeWalkerArray = new ProcessorTreeWalker[]{this};
                return processorTreeWalkerArray;
            }
            ArrayList<ProcessorTreeWalker> list = new ArrayList<ProcessorTreeWalker>();
            StringBuffer buffer = new StringBuffer();
            this.writePart1(buffer);
            if (buffer.toString().length() > 0) {
                LiteralCharactersProcessor part1 = new LiteralCharactersProcessor(buffer.toString());
                BuilderUtil.characterProcessorCopy(this, part1, sequenceIDGenerator);
                list.add(part1);
            }
            Iterator it = this.iterateProcesstimeProperties();
            while (it.hasNext()) {
                prop = (ProcessorProperty)it.next();
                buffer = new StringBuffer();
                this.internalWritePart2(buffer, prop);
                part2 = new CharactersProcessor(prop, buffer.toString());
                BuilderUtil.characterProcessorCopy(this, part2, sequenceIDGenerator);
                list.add(part2);
            }
            it = this.iterateInformalProperties();
            while (it.hasNext()) {
                prop = (ProcessorProperty)it.next();
                if (this.hasProcesstimeProperty(prop) || prop.getValue().isLiteral()) continue;
                buffer = new StringBuffer();
                this.internalWritePart2(buffer, prop);
                part2 = new CharactersProcessor(prop, buffer.toString());
                BuilderUtil.characterProcessorCopy(this, part2, sequenceIDGenerator);
                list.add(part2);
            }
            buffer = new StringBuffer();
            this.writePart3(buffer);
            if (buffer.toString().length() > 0) {
                LiteralCharactersProcessor part3 = new LiteralCharactersProcessor(buffer.toString());
                BuilderUtil.characterProcessorCopy(this, part3, sequenceIDGenerator);
                list.add(part3);
            }
            int size = this.getChildProcessorSize();
            for (int i = 0; i < size; ++i) {
                list.add(this.getChildProcessor(i));
            }
            buffer = new StringBuffer();
            this.writePart4(buffer);
            if (buffer.toString().length() > 0) {
                LiteralCharactersProcessor part4 = new LiteralCharactersProcessor(buffer.toString());
                BuilderUtil.characterProcessorCopy(this, part4, sequenceIDGenerator);
                list.add(part4);
            }
            this.clearChildProcessors();
            this.clearProcesstimeInfo();
            ProcessorTreeWalker[] processorTreeWalkerArray = list.toArray(new ProcessorTreeWalker[list.size()]);
            return processorTreeWalkerArray;
        }
        finally {
            this.renderExit();
        }
    }

    public void kill() {
        this._name = null;
        super.kill();
    }

    protected void optimizeNodes() {
        SpecificationNode originalNode = this.getOriginalNode();
        NodeTreeWalker originalParent = originalNode.getParentNode();
        Iterator it = originalParent.iterateChildNode();
        while (it.hasNext()) {
            if (it.next() != originalNode) continue;
            it.remove();
            break;
        }
        it = this.getOriginalNode().iterateChildNode();
        while (it.hasNext()) {
            NodeTreeWalker child = (NodeTreeWalker)it.next();
            child.setParentNode(originalParent);
            originalParent.addChildNode(child);
        }
        this.getOriginalNode().clearChildNodes();
        this.getOriginalNode().clearAttributes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RENDERED_NS_STACK_KEY = (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor = ElementProcessor.class$("org.seasar.mayaa.impl.engine.processor.ElementProcessor")) : class$org$seasar$mayaa$impl$engine$processor$ElementProcessor).getName() + "#renderedNSStack";
        CURRENT_NS_KEY = (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$ElementProcessor = ElementProcessor.class$("org.seasar.mayaa.impl.engine.processor.ElementProcessor")) : class$org$seasar$mayaa$impl$engine$processor$ElementProcessor).getName() + "#currentNS";
        XHTML_EMPTY_ELEMENTS = new HashSet();
        XHTML_EMPTY_ELEMENTS.add("base");
        XHTML_EMPTY_ELEMENTS.add("meta");
        XHTML_EMPTY_ELEMENTS.add("link");
        XHTML_EMPTY_ELEMENTS.add("hr");
        XHTML_EMPTY_ELEMENTS.add("br");
        XHTML_EMPTY_ELEMENTS.add("param");
        XHTML_EMPTY_ELEMENTS.add("img");
        XHTML_EMPTY_ELEMENTS.add("area");
        XHTML_EMPTY_ELEMENTS.add("input");
        XHTML_EMPTY_ELEMENTS.add("col");
        XHTML_EMPTY_ELEMENTS.add("basefont");
        XHTML_EMPTY_ELEMENTS.add("isindex");
        XHTML_EMPTY_ELEMENTS.add("frame");
        XHTML_EMPTY_ELEMENTS.add("wbr");
        XHTML_EMPTY_ELEMENTS.add("bgsound");
        XHTML_EMPTY_ELEMENTS.add("nextid");
        XHTML_EMPTY_ELEMENTS.add("sound");
        XHTML_EMPTY_ELEMENTS.add("spacer");
        CycleUtil.registVariableFactory(RENDERED_NS_STACK_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                return new Stack();
            }
        });
        CycleUtil.registVariableFactory(CURRENT_NS_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                SpecificationNode originalNode = (SpecificationNode)params[0];
                Namespace currentNS = SpecificationUtil.createNamespace();
                currentNS.setParentSpace(originalNode.getParentSpace());
                Iterator it = originalNode.iteratePrefixMapping(false);
                while (it.hasNext()) {
                    PrefixMapping prefixMapping = (PrefixMapping)it.next();
                    currentNS.addPrefixMapping(prefixMapping.getPrefix(), prefixMapping.getNamespaceURI());
                }
                currentNS.setDefaultNamespaceURI(originalNode.getDefaultNamespaceURI());
                return currentNS;
            }
        });
    }
}

