/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.CharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.ProcessorPropertyImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;

public class CommentProcessor
extends CharactersProcessor
implements CONST_IMPL {
    private static final long serialVersionUID = -5176372123366627130L;
    private static final String COMMENTIN = "<!--";
    private static final String COMMENTOUT = "-->";
    static /* synthetic */ Class class$java$lang$String;

    private void writePart1(StringBuffer buffer) {
        Object value;
        buffer.append(COMMENTIN);
        if (this.getText() != null && (value = CycleUtil.isDraftWriting() ? this.getText().getValue().getScriptText() : this.getText().getValue().execute(null)) != null) {
            buffer.append(value.toString());
        }
    }

    private void writePart2(StringBuffer buffer) {
        buffer.append(COMMENTOUT);
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        StringBuffer buffer = new StringBuffer();
        this.writePart1(buffer);
        cycle.getResponse().write(buffer.toString());
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    public ProcessStatus doEndProcess() {
        StringBuffer buffer = new StringBuffer();
        this.writePart2(buffer);
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(buffer.toString());
        return ProcessStatus.EVAL_PAGE;
    }

    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        if (!this.getOriginalNode().getQName().equals(CONST_IMPL.QM_COMMENT)) {
            return new ProcessorTreeWalker[]{this};
        }
        ProcessorTreeWalker[] results = new ProcessorTreeWalker[2 + this.getChildProcessorSize()];
        if (this.getText() == null) {
            this.setText(this.createVoidText());
        }
        StringBuffer sb = new StringBuffer();
        this.writePart1(sb);
        CharactersProcessor characterProcessor = new CharactersProcessor(this, sb.toString());
        BuilderUtil.characterProcessorCopy(this, characterProcessor, sequenceIDGenerator);
        results[0] = characterProcessor;
        for (int i = 0; i < this.getChildProcessorSize(); ++i) {
            results[i + 1] = this.getChildProcessor(i);
            results[i + 1].setParentProcessor(this.getParentProcessor());
        }
        LiteralCharactersProcessor literal = new LiteralCharactersProcessor(COMMENTOUT);
        BuilderUtil.characterProcessorCopy(this, literal, sequenceIDGenerator);
        results[results.length - 1] = literal;
        this.getParentProcessor().removeProcessor(this);
        return results;
    }

    private ProcessorProperty createVoidText() {
        URI processorDefNameSpace = this.getProcessorDefinition().getLibraryDefinition().getNamespaceURI();
        String processorDefName = this.getProcessorDefinition().getName();
        QName qName = SpecificationUtil.createQName(processorDefNameSpace, processorDefName);
        PrefixAwareName prefixAwareName = SpecificationUtil.createPrefixAwareName(qName, "");
        return new ProcessorPropertyImpl(prefixAwareName, "", class$java$lang$String == null ? (class$java$lang$String = CommentProcessor.class$("java.lang.String")) : class$java$lang$String);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

