/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.script.ScriptUtil;
import org.seasar.mayaa.impl.engine.PageNotFoundException;
import org.seasar.mayaa.impl.engine.RenderUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class PageImpl
extends SpecificationImpl
implements Page,
CONST_IMPL {
    private static final long serialVersionUID = -5345416943673041700L;
    static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$PageImpl == null ? (class$org$seasar$mayaa$impl$engine$PageImpl = PageImpl.class$("org.seasar.mayaa.impl.engine.PageImpl")) : class$org$seasar$mayaa$impl$engine$PageImpl));
    private static final String CURRENT_PAGE_KEY = "__currentPage__";
    private static final String CURRENT_COMPONENT_KEY = "__currentComponent__";
    private String _pageName;
    private transient Page _superPage;
    private transient String _superSuffix;
    private transient String _superExtension;
    private transient Map _beginRenderListeners;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$PageImpl;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(String pageName) {
        if (StringUtil.isEmpty(pageName)) {
            throw new IllegalArgumentException();
        }
        if (pageName.charAt(0) != '/') {
            pageName = "/" + pageName;
        }
        this._pageName = pageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            this._superPage = null;
            this._beginRenderListeners = null;
            super.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareSuper() {
        if (this._superPage != null) {
            return;
        }
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            if (this._superPage != null) {
                return;
            }
            String extendsPath = SpecificationUtil.getMayaaAttributeValue(this, CONST_IMPL.QM_EXTENDS);
            if (StringUtil.isEmpty(extendsPath)) {
                return;
            }
            Engine engine = ProviderUtil.getEngine();
            String suffixSeparator = engine.getParameter("suffixSeparator");
            String[] pagePath = StringUtil.parsePath(extendsPath, suffixSeparator);
            this._superPage = engine.getPage(StringUtil.adjustRelativePath(this._pageName, pagePath[0]));
            this._superSuffix = pagePath[1];
            this._superExtension = pagePath[2];
        }
    }

    public Page getSuperPage() {
        this.prepareSuper();
        return this._superPage;
    }

    public String getSuperSuffix() {
        this.prepareSuper();
        return this._superSuffix;
    }

    public String getSuperExtension() {
        this.prepareSuper();
        return this._superExtension;
    }

    public String getPageName() {
        return this._pageName;
    }

    public CompiledScript getSuffixScript() {
        String value = SpecificationUtil.getMayaaAttributeValue(this, CONST_IMPL.QM_TEMPLATE_SUFFIX);
        if (StringUtil.isEmpty(value)) {
            value = SpecificationUtil.getMayaaAttributeValue(ProviderUtil.getEngine(), CONST_IMPL.QM_TEMPLATE_SUFFIX);
        }
        if (StringUtil.isEmpty(value)) {
            value = "";
        }
        return ScriptUtil.compile(value, class$java$lang$String == null ? (class$java$lang$String = PageImpl.class$("java.lang.String")) : class$java$lang$String);
    }

    protected Template findTemplateFromCache(String systemID) {
        Engine engine = ProviderUtil.getEngine();
        return (Template)engine.findSpecificationFromCache(systemID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Template getTemplateFromFixedSuffix(String suffix, String extension) {
        Engine engine;
        if (suffix == null || extension == null) {
            throw new IllegalArgumentException();
        }
        Engine engine2 = engine = ProviderUtil.getEngine();
        synchronized (engine2) {
            String systemID = engine.getTemplateID(this, suffix, extension);
            Template template = this.findTemplateFromCache(systemID);
            if (template != null) {
                if (template.getSource().exists()) {
                    return template;
                }
                template.kill();
                return null;
            }
            return engine.createTemplateInstance(this, suffix, extension);
        }
    }

    public Template getTemplate(String suffix, String extension) {
        if (suffix == null) {
            suffix = "";
        }
        if (extension == null) {
            extension = "";
        }
        if (CONST_IMPL.QM_MAYAA.getLocalName().equals(extension)) {
            return null;
        }
        Template template = this.getTemplateFromFixedSuffix(suffix, extension);
        if (template == null && StringUtil.hasValue(suffix)) {
            template = this.getTemplateFromFixedSuffix("", extension);
        }
        if (template == null) {
            throw new PageNotFoundException(this._pageName, extension);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public ProcessStatus doPageRender(String requestedSuffix, String extension) {
        Page prevPage = PageImpl.getCurrentPage();
        PageImpl.setCurrentPage(this);
        SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_BEFORE_RENDER_PAGE);
        Page component = this;
        Page superPage = component.getSuperPage();
        if (superPage != null) {
            component = superPage;
        }
        Page prevComponent = PageImpl.getCurrentComponent();
        PageImpl.setCurrentComponent(component);
        SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_BEFORE_RENDER_COMPONENT);
        this.notifyBeginRender();
        ProcessStatus processStatus = RenderUtil.renderPage(true, this, null, this, requestedSuffix, extension);
        Object var9_8 = null;
        PageImpl.setCurrentComponent(component);
        try {
            SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_COMPONENT);
        }
        finally {
            PageImpl.setCurrentComponent(prevComponent);
        }
        Object var12_12 = null;
        PageImpl.setCurrentPage(this);
        try {
            SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PAGE);
        }
        finally {
            PageImpl.setCurrentPage(prevPage);
        }
        {
            return processStatus;
            catch (Throwable throwable) {
                Object var9_9 = null;
                PageImpl.setCurrentComponent(component);
                try {
                    SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_COMPONENT);
                }
                finally {
                    PageImpl.setCurrentComponent(prevComponent);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            PageImpl.setCurrentPage(this);
            try {
                SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_PAGE);
            }
            finally {
                PageImpl.setCurrentPage(prevPage);
            }
            throw throwable;
        }
    }

    protected static Page getCurrentPage() {
        return (Page)CycleUtil.getRequestScope().getAttribute(CURRENT_PAGE_KEY);
    }

    protected static void setCurrentPage(Page page) {
        CycleUtil.getRequestScope().setAttribute(CURRENT_PAGE_KEY, page);
    }

    public static Page getCurrentComponent() {
        return (Page)CycleUtil.getRequestScope().getAttribute(CURRENT_COMPONENT_KEY);
    }

    public static void setCurrentComponent(Page component) {
        CycleUtil.getRequestScope().setAttribute(CURRENT_COMPONENT_KEY, component);
    }

    protected void finalize() throws Throwable {
        this.kill();
        super.finalize();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public ProcessStatus renderTemplate(Page topLevelPage, Template[] templates) {
        if (topLevelPage == null || templates == null || templates.length == 0) {
            throw new IllegalArgumentException();
        }
        return templates[0].doTemplateRender(topLevelPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getBeginRenderListeners() {
        PageImpl pageImpl = this;
        synchronized (pageImpl) {
            if (this._beginRenderListeners == null) {
                this._beginRenderListeners = new ReferenceMap(1, 2, true);
            }
        }
        return this._beginRenderListeners;
    }

    public boolean registBeginRenderNotifier(TemplateProcessor processor) {
        boolean result;
        boolean bl = result = !this.getBeginRenderListeners().containsKey(processor);
        if (!result) {
            this.getBeginRenderListeners().put(processor, Boolean.TRUE);
        }
        return result;
    }

    protected void notifyBeginRender() {
        Iterator it = this.getBeginRenderListeners().keySet().iterator();
        while (it.hasNext()) {
            TemplateProcessor listener = (TemplateProcessor)it.next();
            listener.notifyBeginRender(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

