/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.impl.cycle.scope.AbstractWritableAttributeScope;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.EnumerationIterator;

public class ApplicationScopeImpl
extends AbstractWritableAttributeScope
implements ApplicationScope {
    private static final long serialVersionUID = 5216746677132589700L;
    private transient ServletContext _servletContext;

    protected void check() {
        if (this._servletContext == null) {
            throw new IllegalStateException();
        }
    }

    public String getMimeType(String fileName) {
        this.check();
        if (StringUtil.isEmpty(fileName)) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getMimeType(fileName);
    }

    public String getRealPath(String contextRelatedPath) {
        this.check();
        if (StringUtil.isEmpty(contextRelatedPath)) {
            throw new IllegalArgumentException();
        }
        return this._servletContext.getRealPath(contextRelatedPath);
    }

    public String getScopeName() {
        return "application";
    }

    public Iterator iterateAttributeNames() {
        this.check();
        return EnumerationIterator.getInstance(this._servletContext.getAttributeNames());
    }

    public boolean hasAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        Enumeration e = this._servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        return env.convertFromScriptObject(this._servletContext.getAttribute(name));
    }

    public void setAttribute(String name, Object attribute) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._servletContext.setAttribute(name, attribute);
    }

    public void removeAttribute(String name) {
        this.check();
        if (StringUtil.isEmpty(name)) {
            return;
        }
        this._servletContext.removeAttribute(name);
    }

    public void setUnderlyingContext(Object context) {
        if (context == null || !(context instanceof ServletContext)) {
            throw new IllegalArgumentException();
        }
        this._servletContext = (ServletContext)context;
    }

    public Object getUnderlyingContext() {
        this.check();
        return this._servletContext;
    }
}

