/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.mayaa.PositionAware;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.script.ComplexScript;
import org.seasar.mayaa.impl.cycle.script.LiteralScript;
import org.seasar.mayaa.impl.cycle.script.ScriptBlock;
import org.seasar.mayaa.impl.cycle.script.ScriptBlockIterator;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;
import org.seasar.mayaa.source.SourceDescriptor;

public abstract class AbstractScriptEnvironment
extends ParameterAwareImpl
implements ScriptEnvironment {
    private transient List _attributeScopes;
    private String _blockSign = "$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributeScope(AttributeScope attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException();
        }
        if (this._attributeScopes == null) {
            this._attributeScopes = new ArrayList();
        }
        List list = this._attributeScopes;
        synchronized (list) {
            this._attributeScopes.add(attrs);
        }
    }

    public Iterator iterateAttributeScope() {
        if (this._attributeScopes == null) {
            return NullIterator.getInstance();
        }
        return this._attributeScopes.iterator();
    }

    public void setBlockSign(String blockSign) {
        if (StringUtil.isEmpty(blockSign)) {
            throw new IllegalArgumentException();
        }
        this._blockSign = blockSign;
    }

    public String getBlockSign() {
        return this._blockSign;
    }

    protected abstract CompiledScript compile(ScriptBlock var1, PositionAware var2, int var3);

    public CompiledScript compile(String script, PositionAware position) {
        if (StringUtil.isEmpty(script)) {
            return new LiteralScript("");
        }
        int offsetLine = 0;
        ArrayList<CompiledScript> list = new ArrayList<CompiledScript>();
        ScriptBlockIterator it = new ScriptBlockIterator(script, this._blockSign, position.isOnTemplate());
        while (it.hasNext()) {
            ScriptBlock block = (ScriptBlock)it.next();
            list.add(this.compile(block, position, offsetLine));
            offsetLine += this.lineCount(block.getBlockString());
        }
        if (list.size() == 1) {
            return (CompiledScript)list.get(0);
        }
        CompiledScript[] compiled = list.toArray(new CompiledScript[list.size()]);
        return new ComplexScript(compiled);
    }

    private int lineCount(String str) {
        String[] lines = str.split(System.getProperty("line.separator"));
        return lines.length;
    }

    public abstract /* synthetic */ Object convertFromScriptObject(Object var1);

    public abstract /* synthetic */ void endScope();

    public abstract /* synthetic */ void startScope(Map var1);

    public abstract /* synthetic */ void initScope();

    public abstract /* synthetic */ CompiledScript compile(SourceDescriptor var1, String var2);
}

