/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.cycle.scope.SessionScope;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.cycle.ScopeIterator;
import org.seasar.mayaa.impl.cycle.ScriptFileNotFoundException;
import org.seasar.mayaa.impl.cycle.scope.ScopeNotFoundException;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.source.ApplicationSourceDescriptor;
import org.seasar.mayaa.impl.source.SourceUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public abstract class AbstractServiceCycle
extends ParameterAwareImpl
implements ServiceCycle {
    private static final ReferenceMap _scriptCache = new ReferenceMap(1, 1, true);
    private AttributeScope _page;
    private NodeTreeWalker _originalNode;
    private NodeTreeWalker _injectedNode;
    private ProcessorTreeWalker _processor;
    private Throwable _t;
    private static String ATTRIBUTE_SCOPE_CACHE_KEY = "ATTRIBUTE_SCOPE_CACHE";

    public void load(String systemID) {
        this.load(systemID, "UTF-8");
    }

    public void load(String systemID, String encoding) {
        if (StringUtil.isEmpty(systemID)) {
            throw new ScriptFileNotFoundException(systemID);
        }
        String sid = systemID;
        if (sid.startsWith("/WEB-INF/")) {
            sid = sid.substring(9);
        } else if (StringUtil.isRelativePath(sid)) {
            String sourcePath = EngineUtil.getSourcePath();
            sid = StringUtil.adjustRelativePath(sourcePath, sid);
        }
        CompiledScript script = this.getScript(sid, encoding);
        if (script == null) {
            throw new ScriptFileNotFoundException(systemID);
        }
        script.execute(null);
    }

    protected CompiledScript getScript(String systemID, String encoding) {
        SourceDescriptor source;
        CompiledScript script = (CompiledScript)_scriptCache.get((Object)systemID);
        if (script != null) {
            return script;
        }
        ApplicationSourceDescriptor appSource = new ApplicationSourceDescriptor();
        if (!systemID.startsWith("/")) {
            appSource.setRoot("/WEB-INF");
        }
        appSource.setSystemID(systemID);
        if (appSource.exists()) {
            source = appSource;
        } else {
            source = SourceUtil.getSourceDescriptor(systemID);
            if (!source.exists()) {
                return null;
            }
        }
        ScriptEnvironment env = ProviderUtil.getScriptEnvironment();
        script = env.compile(source, encoding);
        _scriptCache.put((Object)systemID, (Object)script);
        return script;
    }

    public Iterator iterateAttributeScope() {
        Iterator it = ProviderUtil.getScriptEnvironment().iterateAttributeScope();
        return new ScopeIterator(this, it);
    }

    private Map getAttributeScopeCacheMap() {
        return (Map)CycleUtil.getGlobalVariable(ATTRIBUTE_SCOPE_CACHE_KEY, null);
    }

    public AttributeScope findAttributeScope(String scopeName) {
        boolean currentPageScope = false;
        if (scopeName == null) {
            currentPageScope = true;
            scopeName = "page";
        }
        if (!currentPageScope && this.getAttributeScopeCacheMap().containsKey(scopeName)) {
            return (AttributeScope)this.getAttributeScopeCacheMap().get(scopeName);
        }
        Iterator it = this.iterateAttributeScope();
        while (it.hasNext()) {
            AttributeScope scope = (AttributeScope)it.next();
            if (!scope.getScopeName().equals(scopeName)) continue;
            if (currentPageScope) {
                scope = (AttributeScope)scope.getAttribute("__current__");
                return scope;
            }
            this.getAttributeScopeCacheMap().put(scopeName, scope);
            return scope;
        }
        this.getAttributeScopeCacheMap().put(scopeName, null);
        return null;
    }

    public boolean hasAttributeScope(String scopeName) {
        if (StringUtil.isEmpty(scopeName)) {
            scopeName = null;
        }
        return this.findAttributeScope(scopeName) != null;
    }

    public AttributeScope getAttributeScope(String scopeName) {
        AttributeScope result;
        if (StringUtil.isEmpty(scopeName)) {
            scopeName = null;
        }
        if ((result = this.findAttributeScope(scopeName)) == null) {
            throw new ScopeNotFoundException(scopeName);
        }
        return result;
    }

    public void setPageScope(AttributeScope page) {
        this._page = page;
    }

    public AttributeScope getPageScope() {
        return this._page;
    }

    public void setOriginalNode(NodeTreeWalker originalNode) {
        this._originalNode = originalNode;
    }

    public NodeTreeWalker getOriginalNode() {
        return this._originalNode;
    }

    public void setInjectedNode(NodeTreeWalker injectedNode) {
        this._injectedNode = injectedNode;
    }

    public NodeTreeWalker getInjectedNode() {
        return this._injectedNode;
    }

    public void setProcessor(ProcessorTreeWalker processor) {
        this._processor = processor;
    }

    public ProcessorTreeWalker getProcessor() {
        return this._processor;
    }

    public void setHandledError(Throwable t) {
        this._t = t;
    }

    public Throwable getHandledError() {
        return this._t;
    }

    public abstract /* synthetic */ Response getResponse();

    public abstract /* synthetic */ SessionScope getSessionScope();

    public abstract /* synthetic */ RequestScope getRequestScope();

    public abstract /* synthetic */ ApplicationScope getApplicationScope();

    public abstract /* synthetic */ void error(int var1, String var2);

    public abstract /* synthetic */ void error(int var1);

    public abstract /* synthetic */ void redirect(String var1);

    public abstract /* synthetic */ void forward(String var1);

    static {
        CycleUtil.registVariableFactory(ATTRIBUTE_SCOPE_CACHE_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                return new HashMap();
            }
        });
    }
}

