/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.FolderSourceScanner;
import org.seasar.mayaa.impl.builder.library.scanner.JarSourceScanner;
import org.seasar.mayaa.impl.source.FileSourceDescriptor;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.IteratorIterator;

public class ResourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static final long serialVersionUID = 9001235862576049476L;
    private String _root;
    private List _classPath = new ArrayList();
    private List _jars = new ArrayList();
    private Set _extensions = new HashSet();
    private Set _ignores = new HashSet();

    public ResourceScanner() {
        String[] pathArray = System.getProperty("java.class.path", ".").split(File.pathSeparator);
        for (int i = 0; i < pathArray.length; ++i) {
            String path = pathArray[i];
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this._classPath.add(path);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            this._jars.add(path);
        }
    }

    public Iterator scan() {
        String path;
        IteratorIterator itit = new IteratorIterator();
        Iterator it = this._classPath.iterator();
        while (it.hasNext()) {
            File dir;
            path = (String)it.next();
            if (StringUtil.isEmpty(path)) continue;
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path = path + File.separatorChar;
            }
            if (this._root != null && (!(dir = new File(path = path + this._root)).exists() || !dir.isDirectory())) continue;
            FolderSourceScanner folderScanner = new FolderSourceScanner();
            folderScanner.setParameter("folder", path);
            folderScanner.setParameter("recursive", "true");
            folderScanner.setParameter("absolute", "true");
            Iterator extIterator = this._extensions.iterator();
            while (extIterator.hasNext()) {
                folderScanner.setParameter("extension", (String)extIterator.next());
            }
            itit.add(folderScanner.scan());
        }
        it = this._jars.iterator();
        while (it.hasNext()) {
            path = (String)it.next();
            if (StringUtil.isEmpty(path)) continue;
            File jarFile = new File(path);
            JarSourceScanner jarScanner = new JarSourceScanner();
            FileSourceDescriptor descriptor = new FileSourceDescriptor();
            descriptor.setParameter("absolute", "true");
            descriptor.setFile(jarFile);
            descriptor.setSystemID(jarFile.getName());
            jarScanner.setDescriptor(descriptor);
            jarScanner.setParameter("appPath", jarFile.getParent());
            if (this._root != null) {
                jarScanner.setParameter("folder", this._root);
            }
            Iterator ignoreIterator = this._ignores.iterator();
            while (ignoreIterator.hasNext()) {
                jarScanner.setParameter("ignore", (String)ignoreIterator.next());
            }
            Iterator extIterator = this._extensions.iterator();
            while (extIterator.hasNext()) {
                jarScanner.setParameter("extension", (String)extIterator.next());
            }
            itit.add(jarScanner);
        }
        return itit;
    }

    public void setParameter(String name, String value) {
        if ("root".equals(name)) {
            this._root = value;
            if (!StringUtil.isEmpty(this._root) && this._root.charAt(0) == File.separatorChar) {
                this._root = this._root.substring(1);
            }
        } else if ("extension".equals(name)) {
            this._extensions.add(value);
        } else if ("ignore".equals(name)) {
            this._ignores.add(value);
        } else {
            super.setParameter(name, value);
        }
    }
}

