/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.builder.library.PropertyDefinition;
import org.seasar.mayaa.builder.library.PropertySet;
import org.seasar.mayaa.builder.library.converter.PropertyConverter;
import org.seasar.mayaa.engine.processor.InformalPropertyAcceptable;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.processor.VirtualPropertyAcceptable;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.library.ConverterNotFoundException;
import org.seasar.mayaa.impl.builder.library.ConverterOperationException;
import org.seasar.mayaa.impl.builder.library.PropertySetImpl;
import org.seasar.mayaa.impl.builder.library.PropertySetNotFoundException;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class ProcessorDefinitionImpl
extends PropertySetImpl
implements ProcessorDefinition,
CONST_IMPL {
    private static final long serialVersionUID = -9158405427849768423L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl = ProcessorDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.ProcessorDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl));
    private Class _processorClass;
    private List _propertySetRefs;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$processor$TemplateProcessor;

    public void setProcessorClass(Class processorClass) {
        if (processorClass == null || !(class$org$seasar$mayaa$engine$processor$TemplateProcessor == null ? (class$org$seasar$mayaa$engine$processor$TemplateProcessor = ProcessorDefinitionImpl.class$("org.seasar.mayaa.engine.processor.TemplateProcessor")) : class$org$seasar$mayaa$engine$processor$TemplateProcessor).isAssignableFrom(processorClass)) {
            throw new IllegalArgumentException();
        }
        this._processorClass = processorClass;
    }

    public Class getProcessorClass() {
        return this._processorClass;
    }

    public void addPropertySetRef(String name, String systemID, int lineNumber) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._propertySetRefs == null) {
            this._propertySetRefs = new ArrayList();
        }
        if (this._propertySetRefs.contains(name)) {
            if (LOG.isWarnEnabled()) {
                String line = Integer.toString(lineNumber);
                LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl = ProcessorDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.ProcessorDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl, 1, name, systemID, line));
            }
        } else {
            this._propertySetRefs.add(new PropertySetRef(name, systemID, lineNumber));
        }
    }

    public Iterator iteratePropertySets() {
        if (this._propertySetRefs == null) {
            return NullIterator.getInstance();
        }
        Iterator it = this._propertySetRefs.iterator();
        return new PropertySetIterator(it, this.getLibraryDefinition());
    }

    protected TemplateProcessor newInstance() {
        return (TemplateProcessor)ObjectUtil.newInstance(this._processorClass);
    }

    protected PrefixAwareName getPrefixAwareName(SpecificationNode injected, String propertyName) {
        QName qName = SpecificationUtil.createQName(injected.getQName().getNamespaceURI(), propertyName);
        NodeAttribute attr = injected.getAttribute(qName);
        PrefixAwareName name = SpecificationUtil.createPrefixAwareName(attr.getQName(), attr.getPrefix());
        return name;
    }

    protected void settingProperty(SpecificationNode original, SpecificationNode injected, TemplateProcessor processor, PropertyDefinition property) {
        Object value = property.createProcessorProperty(this, original, injected);
        if (value != null) {
            String propertyImplName = property.getImplName();
            Class processorClass = this.getProcessorClass();
            if (ObjectUtil.hasProperty(processorClass, propertyImplName)) {
                if (value instanceof PrefixAwareName) {
                    value = this.settingDefaultNamespace(original, (PrefixAwareName)value);
                }
                ObjectUtil.setProperty(processor, propertyImplName, value);
            } else if (processor instanceof VirtualPropertyAcceptable) {
                VirtualPropertyAcceptable acceptable = (VirtualPropertyAcceptable)((Object)processor);
                PrefixAwareName name = this.getPrefixAwareName(injected, property.getName());
                acceptable.addVirtualProperty(name, value);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl = ProcessorDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.ProcessorDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$ProcessorDefinitionImpl, 2, processorClass.getName(), propertyImplName));
            }
        }
    }

    protected PrefixAwareName settingDefaultNamespace(SpecificationNode original, PrefixAwareName value) {
        QName valueName = value.getQName();
        if (CONST_IMPL.URI_MAYAA.equals(valueName.getNamespaceURI()) && StringUtil.isEmpty(value.getPrefix())) {
            QName qName = SpecificationUtil.createQName(original.getDefaultNamespaceURI(), valueName.getLocalName());
            value = SpecificationUtil.createPrefixAwareName(qName, "");
        }
        return value;
    }

    protected void settingPropertySet(SpecificationNode original, SpecificationNode injected, TemplateProcessor processor, PropertySet propertySet) {
        Iterator it = propertySet.iteratePropertyDefinition();
        while (it.hasNext()) {
            PropertyDefinition property = (PropertyDefinition)it.next();
            this.settingProperty(original, injected, processor, property);
        }
    }

    protected void settingInformalProperties(SpecificationNode injected, InformalPropertyAcceptable acceptable) {
        URI injectedNS = injected.getQName().getNamespaceURI();
        Iterator it = injected.iterateAttribute();
        while (it.hasNext()) {
            Class propertyClass;
            NodeAttribute attr = (NodeAttribute)it.next();
            if (this.contain(injectedNS, attr)) continue;
            LibraryDefinition library = this.getLibraryDefinition();
            PropertyConverter converter = library.getPropertyConverter(propertyClass = acceptable.getPropertyClass());
            if (converter == null) {
                throw new ConverterNotFoundException(propertyClass.getName(), this.getSystemID(), this.getLineNumber());
            }
            Class expectedClass = acceptable.getExpectedClass();
            String value = attr.getValue();
            Serializable property = converter.convert(attr, value, expectedClass);
            if (property == null) {
                throw new ConverterOperationException(converter, value);
            }
            PrefixAwareName name = SpecificationUtil.createPrefixAwareName(attr.getQName(), attr.getPrefix());
            acceptable.addInformalProperty(name, property);
        }
    }

    public TemplateProcessor createTemplateProcessor(SpecificationNode original, SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        TemplateProcessor processor = this.newInstance();
        processor.setProcessorDefinition(this);
        this.settingPropertySet(original, injected, processor, this);
        Iterator it = this.iteratePropertySets();
        while (it.hasNext()) {
            PropertySet propertySet = (PropertySet)it.next();
            this.settingPropertySet(original, injected, processor, propertySet);
        }
        if (processor instanceof InformalPropertyAcceptable) {
            this.settingInformalProperties(injected, (InformalPropertyAcceptable)((Object)processor));
        }
        return processor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PropertySetIterator
    implements Iterator {
        private Iterator _it;
        private LibraryDefinition _library;

        public PropertySetIterator(Iterator it, LibraryDefinition library) {
            if (it == null || library == null) {
                throw new IllegalArgumentException();
            }
            this._it = it;
            this._library = library;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            PropertySetRef ref = (PropertySetRef)this._it.next();
            PropertySet propertySet = this._library.getPropertySet(ref.getName());
            if (propertySet == null) {
                throw new PropertySetNotFoundException(ref.getName(), ref.getSystemID(), ref.getLineNumber());
            }
            return propertySet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class PropertySetRef
    implements Serializable {
        private static final long serialVersionUID = -3425332447146558868L;
        private String _name;
        private String _systemID;
        private int _lineNumber;

        public PropertySetRef(String name, String systemID, int lineNumber) {
            if (StringUtil.isEmpty(name) || StringUtil.isEmpty(systemID) || lineNumber < 0) {
                throw new IllegalArgumentException();
            }
            this._name = name;
            this._systemID = systemID;
            this._lineNumber = lineNumber;
        }

        public String getName() {
            return this._name;
        }

        public String getSystemID() {
            return this._systemID;
        }

        public int getLineNumber() {
            return this._lineNumber;
        }
    }
}

