/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.PositionAware;
import org.seasar.mayaa.builder.library.DefinitionBuilder;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.builder.library.converter.PropertyConverter;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.SourceAlias;
import org.seasar.mayaa.impl.builder.library.scanner.WebXMLTaglibSourceScanner;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.AbstractScanningIterator;
import org.seasar.mayaa.source.SourceDescriptor;

public class LibraryManagerImpl
extends ParameterAwareImpl
implements LibraryManager {
    private static final long serialVersionUID = -2346419518053103604L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl == null ? (class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl = LibraryManagerImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryManagerImpl")) : class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl));
    private List _scanners = new ArrayList();
    private List _builders = new ArrayList();
    private List _libraries;
    private Map _converters = new HashMap();
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl;

    protected void warnAlreadyRegisted(PositionAware obj, String name, int index) {
        if (LOG.isWarnEnabled()) {
            String systemID = obj.getSystemID();
            String lineNumber = Integer.toString(obj.getLineNumber());
            LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl == null ? (class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl = LibraryManagerImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryManagerImpl")) : class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl, index, name, systemID, lineNumber));
        }
    }

    public void addPropertyConverter(String name, PropertyConverter propertyConverter) {
        if (propertyConverter == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(name)) {
            name = propertyConverter.getPropetyClass().getName();
        }
        if (this._converters.containsKey(name)) {
            this.warnAlreadyRegisted(propertyConverter, name, 1);
        } else {
            this._converters.put(name, propertyConverter);
        }
    }

    public PropertyConverter getPropertyConverter(String converterName) {
        if (StringUtil.isEmpty(converterName)) {
            throw new IllegalArgumentException();
        }
        return (PropertyConverter)this._converters.get(converterName);
    }

    public PropertyConverter getPropertyConverter(Class propertyClass) {
        if (propertyClass == null) {
            throw new IllegalArgumentException();
        }
        Iterator it = this._converters.values().iterator();
        while (it.hasNext()) {
            PropertyConverter propertyConverter = (PropertyConverter)it.next();
            Class converterClass = propertyConverter.getPropetyClass();
            if (!propertyClass.isAssignableFrom(converterClass)) continue;
            return propertyConverter;
        }
        return null;
    }

    public Iterator iteratePropertyConverters() {
        return this._converters.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceScanner(SourceScanner scanner) {
        if (scanner == null) {
            throw new IllegalArgumentException();
        }
        List list = this._scanners;
        synchronized (list) {
            if (this._scanners.contains(scanner)) {
                this.warnAlreadyRegisted(scanner, scanner.getClass().getName(), 1);
            } else {
                this._scanners.add(scanner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinitionBuilder(DefinitionBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException();
        }
        List list = this._builders;
        synchronized (list) {
            if (this._builders.contains(builder)) {
                this.warnAlreadyRegisted(builder, builder.getClass().getName(), 3);
            } else {
                this._builders.add(builder);
            }
        }
    }

    public void prepareLibraries() {
        if (this._libraries == null) {
            this.buildAll();
        }
    }

    protected void buildAll() {
        this._libraries = new ArrayList();
        HashSet<URI> builtLibraries = new HashSet<URI>();
        for (int i = 0; i < this._scanners.size(); ++i) {
            SourceScanner scanner = (SourceScanner)this._scanners.get(i);
            Iterator it = scanner.scan();
            while (it.hasNext()) {
                SourceDescriptor source = (SourceDescriptor)it.next();
                boolean built = false;
                for (int k = 0; k < this._builders.size(); ++k) {
                    DefinitionBuilder builder = (DefinitionBuilder)this._builders.get(k);
                    LibraryDefinition library = builder.build(source);
                    if (library == null) continue;
                    if (!builtLibraries.contains(library.getNamespaceURI())) {
                        this._libraries.add(library);
                        builtLibraries.add(library.getNamespaceURI());
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl == null ? LibraryManagerImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryManagerImpl") : class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl, 4, source.getSystemID(), String.valueOf(library.getNamespaceURI())));
                        }
                    }
                    built = true;
                    break;
                }
                if (built) continue;
                this.assignTaglibLocation(source);
            }
        }
    }

    private void assignTaglibLocation(SourceDescriptor source) {
        String realPath = source.getParameter(WebXMLTaglibSourceScanner.REAL_PATH);
        if (StringUtil.isEmpty(realPath) || !realPath.endsWith(".jar")) {
            return;
        }
        for (int j = 0; j < this._libraries.size(); ++j) {
            LibraryDefinition library = (LibraryDefinition)this._libraries.get(j);
            Iterator it = library.iterateAssignedURI();
            while (it.hasNext()) {
                URI uri = (URI)it.next();
                if (!realPath.equals(String.valueOf(uri))) continue;
                URI assignedURI = SpecificationUtil.createURI(source.getParameter(SourceAlias.ALIAS));
                library.addAssignedURI(assignedURI);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl == null ? (class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl = LibraryManagerImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryManagerImpl")) : class$org$seasar$mayaa$impl$builder$library$LibraryManagerImpl, 4, library.getNamespaceURI() + " (alias)", String.valueOf(assignedURI)));
                }
                return;
            }
        }
    }

    public Iterator iterateLibraryDefinition() {
        this.prepareLibraries();
        return this._libraries.iterator();
    }

    public Iterator iterateLibraryDefinition(URI namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        return new LibraryDefinitionFilteredIterator(namespaceURI, this.iterateLibraryDefinition());
    }

    public ProcessorDefinition getProcessorDefinition(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        URI namespaceURI = qName.getNamespaceURI();
        String localName = qName.getLocalName();
        Iterator it = this.iterateLibraryDefinition(namespaceURI);
        while (it.hasNext()) {
            LibraryDefinition library = (LibraryDefinition)it.next();
            ProcessorDefinition processor = library.getProcessorDefinition(localName);
            if (processor == null) continue;
            return processor;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LibraryDefinitionFilteredIterator
    extends AbstractScanningIterator {
        private URI _namespaceURI;

        public LibraryDefinitionFilteredIterator(URI namespaceURI, Iterator iterator) {
            super(iterator);
            if (StringUtil.isEmpty(namespaceURI)) {
                throw new IllegalArgumentException();
            }
            this._namespaceURI = namespaceURI;
        }

        protected boolean filter(Object test) {
            if (test == null || !(test instanceof LibraryDefinition)) {
                return false;
            }
            LibraryDefinition library = (LibraryDefinition)test;
            if (this._namespaceURI.equals(library.getNamespaceURI())) {
                return true;
            }
            Iterator it = library.iterateAssignedURI();
            while (it.hasNext()) {
                if (!this._namespaceURI.equals(it.next())) continue;
                return true;
            }
            return false;
        }
    }
}

