/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.PositionAware;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.builder.library.PropertySet;
import org.seasar.mayaa.builder.library.converter.PropertyConverter;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class LibraryDefinitionImpl
extends ParameterAwareImpl
implements LibraryDefinition {
    private static final long serialVersionUID = -2112164511711535994L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl = LibraryDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl));
    private URI _namespaceURI;
    private List _assignedURI = new ArrayList();
    private Map _converters;
    private Map _propertySets;
    private Map _processors;
    private String _systemID;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl;

    public void setSystemID(String systemID) {
        if (StringUtil.isEmpty(systemID)) {
            throw new IllegalArgumentException();
        }
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setNamespaceURI(URI namespaceURI) {
        if (StringUtil.isEmpty(namespaceURI)) {
            throw new IllegalArgumentException();
        }
        this._namespaceURI = namespaceURI;
    }

    public URI getNamespaceURI() {
        return this._namespaceURI;
    }

    public void addAssignedURI(URI assignedURI) {
        if (StringUtil.isEmpty(assignedURI)) {
            throw new IllegalArgumentException();
        }
        if (!assignedURI.equals(this._namespaceURI) && !this._assignedURI.contains(assignedURI)) {
            this._assignedURI.add(assignedURI);
        }
    }

    public Iterator iterateAssignedURI() {
        return this._assignedURI.iterator();
    }

    protected void warnAlreadyRegisted(PositionAware obj, String name, int index) {
        if (LOG.isWarnEnabled()) {
            String systemID = obj.getSystemID();
            String lineNumber = Integer.toString(obj.getLineNumber());
            LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl = LibraryDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.LibraryDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$LibraryDefinitionImpl, index, name, systemID, lineNumber));
        }
    }

    public void addPropertyConverter(String name, PropertyConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(name)) {
            name = converter.getPropetyClass().getName();
        }
        if (this._converters == null) {
            this._converters = new HashMap();
        }
        if (this._converters.containsKey(name)) {
            this.warnAlreadyRegisted(converter, name, 1);
        } else {
            this._converters.put(name, converter);
        }
    }

    public PropertyConverter getPropertyConverter(Class propertyClass) {
        if (propertyClass == null) {
            throw new IllegalArgumentException();
        }
        if (this._converters != null) {
            Iterator it = this._converters.values().iterator();
            while (it.hasNext()) {
                PropertyConverter converter = (PropertyConverter)it.next();
                if (!propertyClass.equals(converter.getPropetyClass())) continue;
                return converter;
            }
        }
        LibraryManager manager = ProviderUtil.getLibraryManager();
        return manager.getPropertyConverter(propertyClass);
    }

    public PropertyConverter getPropertyConverter(String converterName) {
        if (StringUtil.isEmpty(converterName)) {
            throw new IllegalArgumentException();
        }
        if (this._converters != null && this._converters.containsKey(converterName)) {
            return (PropertyConverter)this._converters.get(converterName);
        }
        LibraryManager manager = ProviderUtil.getLibraryManager();
        return manager.getPropertyConverter(converterName);
    }

    public Iterator iteratePropertyConverters() {
        if (this._converters == null) {
            return NullIterator.getInstance();
        }
        return this._converters.values().iterator();
    }

    public void addPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        String name = propertySet.getName();
        if (this._propertySets == null) {
            this._propertySets = new HashMap();
        }
        if (this._propertySets.containsKey(name)) {
            this.warnAlreadyRegisted(propertySet, name, 2);
        } else {
            this._propertySets.put(name, propertySet);
        }
    }

    public Iterator iteratePropertySets() {
        if (this._propertySets == null) {
            return NullIterator.getInstance();
        }
        return this._propertySets.values().iterator();
    }

    public PropertySet getPropertySet(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._propertySets == null) {
            return null;
        }
        return (PropertySet)this._propertySets.get(name);
    }

    public void addProcessorDefinition(ProcessorDefinition processor) {
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        String name = processor.getName();
        if (this._processors == null) {
            this._processors = new HashMap();
        }
        if (this._processors.containsKey(name)) {
            this.warnAlreadyRegisted(processor, name, 3);
        } else {
            this._processors.put(name, processor);
        }
    }

    public Iterator iterateProcessorDefinitions() {
        if (this._processors == null) {
            return NullIterator.getInstance();
        }
        return this._processors.values().iterator();
    }

    public ProcessorDefinition getProcessorDefinition(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._processors == null) {
            return null;
        }
        return (ProcessorDefinition)this._processors.get(name);
    }

    public String toString() {
        String key;
        StringBuffer sb = new StringBuffer();
        sb.append("LibraryDefinition: ");
        sb.append("systemID = ");
        sb.append(this._systemID);
        sb.append(", namespaceUrl = ");
        sb.append(this._namespaceURI);
        sb.append(", assignedURI = (");
        Iterator<Object> it = this._assignedURI.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(", ");
        }
        sb.append("), ");
        if (this._processors != null) {
            sb.append("processors = (");
            it = this._processors.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                ProcessorDefinition def = this.getProcessorDefinition(key);
                sb.append(def.getName());
                sb.append(" - ");
                sb.append(def.getProcessorClass());
                sb.append(", ");
            }
            sb.append("), ");
        }
        if (this._propertySets != null) {
            sb.append("propertySets = (");
            it = this._propertySets.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                PropertySet prop = this.getPropertySet(key);
                sb.append(prop.getName());
                sb.append(" = ");
                sb.append(prop.getParameter(prop.getName()));
                sb.append(", ");
            }
            sb.append("), ");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

