/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.injection;

import java.util.Iterator;
import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.builder.injection.InjectionResolver;
import org.seasar.mayaa.engine.specification.CopyToFilter;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.NodeObject;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.engine.specification.xpath.XPathUtil;

public class XPathMatchesInjectionResolver
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    private static final long serialVersionUID = -5357509098529015227L;
    protected static final QName QM_XPATH = SpecificationUtil.createQName("xpath");
    private CopyToFilter _xpathFilter = new CheckXPathCopyToFilter();

    protected CopyToFilter getCopyToFilter() {
        return this._xpathFilter;
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        Namespace namespace = SpecificationUtil.createNamespace();
        namespace.addPrefixMapping("m", CONST_IMPL.URI_MAYAA);
        String xpathExpr = "/m:mayaa//*[string-length(@m:xpath) > 0]";
        Iterator it = XPathUtil.selectChildNodes(original, xpathExpr, namespace, true);
        while (it.hasNext()) {
            SpecificationNode injected = (SpecificationNode)it.next();
            String mayaaPath = SpecificationUtil.getAttributeValue(injected, QM_XPATH);
            if (!XPathUtil.matches(original, mayaaPath, injected)) continue;
            return injected.copyTo(this.getCopyToFilter());
        }
        return chain.getNode(original);
    }

    protected class CheckXPathCopyToFilter
    implements CopyToFilter {
        protected CheckXPathCopyToFilter() {
        }

        public boolean accept(NodeObject test) {
            if (test instanceof NodeAttribute) {
                NodeAttribute attr = (NodeAttribute)test;
                return !attr.getQName().equals(QM_XPATH);
            }
            return true;
        }
    }
}

