/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.injection;

import org.seasar.mayaa.builder.injection.InjectionChain;
import org.seasar.mayaa.builder.injection.InjectionResolver;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class MetaValuesSetter
extends ParameterAwareImpl
implements InjectionResolver,
CONST_IMPL {
    private static final long serialVersionUID = 3263443313691061874L;
    protected static final QName QH_CONTENT = SpecificationUtil.createQName(CONST_IMPL.URI_HTML, "content");
    protected static final QName QH_HTTP_EQUIV = SpecificationUtil.createQName(CONST_IMPL.URI_HTML, "http-equiv");
    protected static final QName QH_META = SpecificationUtil.createQName(CONST_IMPL.URI_HTML, "meta");
    protected static final QName QX_CONTENT = SpecificationUtil.createQName(CONST_IMPL.URI_XHTML, "content");
    protected static final QName QX_HTTP_EQUIV = SpecificationUtil.createQName(CONST_IMPL.URI_XHTML, "http-equiv");
    protected static final QName QX_META = SpecificationUtil.createQName(CONST_IMPL.URI_XHTML, "meta");

    protected void addMayaaAttribute(SpecificationNode original, QName qName, String value) {
        if (original == null || qName == null || StringUtil.isEmpty(value)) {
            throw new IllegalArgumentException();
        }
        SpecificationNode mayaa = SpecificationUtil.getMayaaNode(original);
        if (mayaa == null) {
            throw new IllegalStateException("mayaaNode not found in current specification");
        }
        mayaa.addAttribute(qName, value);
    }

    protected void setEquiv(SpecificationNode original, String equivValue, String contentValue) {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.hasValue(contentValue)) {
            if ("Content-Type".equalsIgnoreCase(equivValue)) {
                this.addMayaaAttribute(original, CONST_IMPL.QM_CONTENT_TYPE, contentValue);
            } else if (("Pragma".equalsIgnoreCase(equivValue) || "Cache-Control".equalsIgnoreCase(equivValue)) && "no-cache".equalsIgnoreCase(contentValue)) {
                this.addMayaaAttribute(original, CONST_IMPL.QM_NO_CACHE, "true");
            }
        }
    }

    protected void setContentValue(SpecificationNode original, QName httpEquivName, QName contentName) {
        NodeAttribute content;
        NodeAttribute equiv = original.getAttribute(httpEquivName);
        if (equiv != null && (content = original.getAttribute(contentName)) != null) {
            this.setEquiv(original, equiv.getValue(), content.getValue());
        }
    }

    public SpecificationNode getNode(SpecificationNode original, InjectionChain chain) {
        if (original == null || chain == null) {
            throw new IllegalArgumentException();
        }
        QName originalName = original.getQName();
        if (QH_META.equals(originalName)) {
            this.setContentValue(original, QH_HTTP_EQUIV, QH_CONTENT);
        } else if (QX_META.equals(originalName)) {
            this.setContentValue(original, QX_HTTP_EQUIV, QX_CONTENT);
        }
        return chain.getNode(original);
    }
}

