/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder;

import org.seasar.mayaa.builder.PathAdjuster;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.util.StringUtil;

public class PathAdjusterImpl
extends ParameterAwareImpl
implements PathAdjuster,
CONST_IMPL {
    private static final long serialVersionUID = -6683061623840171581L;
    private String[][] _adjustTarget;
    private boolean _enabled = true;

    public PathAdjusterImpl() {
        this(new String[][]{{"a", "href"}, {"img", "src"}, {"link", "href"}, {"script", "src"}, {"form", "action"}, {"input", "src"}, {"area", "href"}, {"iframe", "src"}, {"frame", "src"}, {"frame", "longdesc"}, {"img", "usemap"}, {"input", "usemap"}, {"embed", "src"}, {"applet", "code"}, {"applet", "codebase"}, {"object", "data"}, {"object", "codebase"}, {"object", "usemap"}, {"base", "href"}, {"blockquote", "cite"}, {"del", "cite"}, {"ins", "cite"}, {"q", "cite"}});
    }

    public PathAdjusterImpl(String[][] adjustTarget) {
        this._adjustTarget = adjustTarget;
    }

    public void setParameter(String name, String value) {
        if ("enabled".equals(name)) {
            this._enabled = Boolean.valueOf(value);
        }
        super.setParameter(name, value);
    }

    public boolean isTargetNode(QName nodeName) {
        if (!this._enabled) {
            return false;
        }
        URI uri = nodeName.getNamespaceURI();
        if (CONST_IMPL.URI_HTML.equals(uri) || CONST_IMPL.URI_XHTML.equals(uri)) {
            String local = nodeName.getLocalName().toLowerCase();
            for (int i = 0; i < this._adjustTarget.length; ++i) {
                if (!this._adjustTarget[i][0].equals(local)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetAttribute(QName nodeName, QName attributeName) {
        if (!this._enabled) {
            return false;
        }
        String nodeLocal = nodeName.getLocalName().toLowerCase();
        String attributeLocal = attributeName.getLocalName().toLowerCase();
        for (int i = 0; i < this._adjustTarget.length; ++i) {
            if (!this._adjustTarget[i][0].equals(nodeLocal) || !this._adjustTarget[i][1].equals(attributeLocal)) continue;
            return true;
        }
        return false;
    }

    public String adjustRelativePath(String base, String path) {
        return StringUtil.adjustRelativePath(base, path);
    }
}

