/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class BigDecimalConversionUtil {
    private BigDecimalConversionUtil() {
    }

    public static BigDecimal toBigDecimal(Object o) {
        return BigDecimalConversionUtil.toBigDecimal(o, null);
    }

    public static BigDecimal toBigDecimal(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof String) {
            return new BigDecimal((String)o);
        }
        if (o instanceof Double) {
            return new BigDecimal((Double)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new BigDecimal(new SimpleDateFormat(pattern).format(o));
            }
            return new BigDecimal(Long.toString(((Date)o).getTime()));
        }
        return new BigDecimal(o.toString());
    }
}

