/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.seasar.framework.mock.servlet.MockHeaderUtil;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpSessionImpl;
import org.seasar.framework.mock.servlet.MockRequestDispatcherImpl;
import org.seasar.framework.util.EmptyEnumeration;
import org.seasar.framework.util.EnumerationAdapter;

public class MockHttpServletRequestImpl
implements MockHttpServletRequest {
    private ServletContext servletContext;
    private String servletPath;
    private String authType;
    private List cookieList = new ArrayList();
    private Map headers = new HashMap();
    private String method = "POST";
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private MockHttpSessionImpl session;
    private String scheme = "http";
    private int serverPort = 80;
    private String protocol = "HTTP/1.1";
    private String serverName = "localhost";
    private Map attributes = new HashMap();
    private String characterEncoding = "ISO-8859-1";
    private int contentLength;
    private String contentType;
    private Map parameters = new HashMap();
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private String localAddr;
    private String localName;
    private int localPort;
    private List locales = new ArrayList();

    public MockHttpServletRequestImpl(ServletContext servletContext, String servletPath) {
        this.servletContext = servletContext;
        this.servletPath = servletPath.charAt(0) == '/' ? servletPath : "/" + servletPath;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getDateValue(value);
    }

    public String getHeader(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return new EnumerationAdapter(values.iterator());
        }
        return new EmptyEnumeration();
    }

    public Enumeration getHeaderNames() {
        return new EnumerationAdapter(this.headers.keySet().iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getIntValue(value);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    private List getHeaderList(String name) {
        name = name.toLowerCase();
        return (List)this.headers.get(name);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getContextPath() {
        return this.servletContext.getServletContextName();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    public String getRequestURI() {
        String contextPath = this.getContextPath();
        if (contextPath.equals("/")) {
            return this.servletPath;
        }
        return contextPath + this.servletPath;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        url.append(this.scheme);
        url.append("://");
        url.append(this.serverName);
        if (this.scheme.equals("http") && this.serverPort != 80 || this.scheme.equals("https") && this.serverPort != 443) {
            url.append(':');
            url.append(this.serverPort);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        if (create) {
            this.session = new MockHttpSessionImpl(this.servletContext);
        }
        if (this.session != null) {
            this.session.access();
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session != null) {
            return this.session.isValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.session != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration getParameterNames() {
        return new EnumerationAdapter(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public void addParameter(String name, String value) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            this.setParameter(name, value);
        } else {
            String[] newArray = new String[values.length + 1];
            System.arraycopy(values, 0, newArray, 0, values.length);
            newArray[newArray.length - 1] = value;
            this.parameters.put(name, newArray);
        }
    }

    public void addParameter(String name, String[] values) {
        if (values == null) {
            this.setParameter(name, (String)null);
            return;
        }
        String[] vals = this.getParameterValues(name);
        if (vals == null) {
            this.setParameter(name, values);
        } else {
            String[] newArray = new String[vals.length + values.length];
            System.arraycopy(vals, 0, newArray, 0, vals.length);
            System.arraycopy(values, 0, newArray, vals.length, values.length);
            this.parameters.put(name, newArray);
        }
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public Locale getLocale() {
        if (this.locales.isEmpty()) {
            return null;
        }
        return (Locale)this.locales.get(0);
    }

    public void setLocale(Locale locale) {
        this.locales.clear();
        this.locales.add(locale);
    }

    public Enumeration getLocales() {
        return new EnumerationAdapter(this.locales.iterator());
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcherImpl();
    }

    public String getRealPath(String path) {
        return path;
    }
}

