/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.convention.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public class NamingConventionImpl
implements NamingConvention,
Disposable {
    private static final char PACKAGE_SEPARATOR = '_';
    private static final String PACKAGE_SEPARATOR_STR = "_";
    private boolean initialized;
    private String viewRootPath = "/view";
    private String viewExtension = ".html";
    private String implementationSuffix = "Impl";
    private String pageSuffix = "Page";
    private String actionSuffix = "Action";
    private String serviceSuffix = "Service";
    private String dxoSuffix = "Dxo";
    private String logicSuffix = "Logic";
    private String daoSuffix = "Dao";
    private String helperSuffix = "Helper";
    private String interceptorSuffix = "Interceptor";
    private String validatorSuffix = "Validator";
    private String converterSuffix = "Converter";
    private String dtoSuffix = "Dto";
    private String connectorSuffix = "Connector";
    private String subApplicationRootPackageName = "web";
    private String entityPackageName = "entity";
    private String[] rootPackageNames = new String[0];
    private Map existCheckerArrays = Collections.synchronizedMap(new HashMap());

    public synchronized void initialize() {
        if (!this.initialized) {
            for (int i = 0; i < this.rootPackageNames.length; ++i) {
                this.addExistChecker(this.rootPackageNames[i]);
            }
            DisposableUtil.add(this);
            this.initialized = true;
        }
    }

    public synchronized void dispose() {
        this.existCheckerArrays.clear();
        this.initialized = false;
    }

    public String getPageSuffix() {
        return this.pageSuffix;
    }

    public void setPageSuffix(String pageSuffix) {
        this.pageSuffix = pageSuffix;
    }

    public String getActionSuffix() {
        return this.actionSuffix;
    }

    public void setActionSuffix(String actionSuffix) {
        this.actionSuffix = actionSuffix;
    }

    public String getConnectorSuffix() {
        return this.connectorSuffix;
    }

    public void setConnectorSuffix(String connectorSuffix) {
        this.connectorSuffix = connectorSuffix;
    }

    public String getDaoSuffix() {
        return this.daoSuffix;
    }

    public void setDaoSuffix(String daoSuffix) {
        this.daoSuffix = daoSuffix;
    }

    public String getDtoSuffix() {
        return this.dtoSuffix;
    }

    public void setDtoSuffix(String dtoSuffix) {
        this.dtoSuffix = dtoSuffix;
    }

    public String getDxoSuffix() {
        return this.dxoSuffix;
    }

    public void setDxoSuffix(String dxoSuffix) {
        this.dxoSuffix = dxoSuffix;
    }

    public String getHelperSuffix() {
        return this.helperSuffix;
    }

    public void setHelperSuffix(String helperSuffix) {
        this.helperSuffix = helperSuffix;
    }

    public String getInterceptorSuffix() {
        return this.interceptorSuffix;
    }

    public void setInterceptorSuffix(String interceptorSuffix) {
        this.interceptorSuffix = interceptorSuffix;
    }

    public String getLogicSuffix() {
        return this.logicSuffix;
    }

    public void setLogicSuffix(String logicSuffix) {
        this.logicSuffix = logicSuffix;
    }

    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    public String getValidatorSuffix() {
        return this.validatorSuffix;
    }

    public void setValidatorSuffix(String validatorSuffix) {
        this.validatorSuffix = validatorSuffix;
    }

    public String getConverterSuffix() {
        return this.converterSuffix;
    }

    public void setConverterSuffix(String converterSuffix) {
        this.converterSuffix = converterSuffix;
    }

    public String getImplementationSuffix() {
        return this.implementationSuffix;
    }

    public void setImplementationSuffix(String implementationSuffix) {
        this.implementationSuffix = implementationSuffix;
    }

    public String getDaoPackageName() {
        return this.fromSuffixToPackageName(this.daoSuffix);
    }

    public String getDtoPackageName() {
        return this.fromSuffixToPackageName(this.dtoSuffix);
    }

    public String getDxoPackageName() {
        return this.fromSuffixToPackageName(this.dxoSuffix);
    }

    public String getHelperPackageName() {
        return this.fromSuffixToPackageName(this.helperSuffix);
    }

    public String getInterceptorPackageName() {
        return this.fromSuffixToPackageName(this.interceptorSuffix);
    }

    public String getLogicPackageName() {
        return this.fromSuffixToPackageName(this.logicSuffix);
    }

    public String getServicePackageName() {
        return this.fromSuffixToPackageName(this.serviceSuffix);
    }

    public String getValidatorPackageName() {
        return this.fromSuffixToPackageName(this.validatorSuffix);
    }

    public String getConverterPackageName() {
        return this.fromSuffixToPackageName(this.converterSuffix);
    }

    public String getConnectorPackageName() {
        return this.fromSuffixToPackageName(this.connectorSuffix);
    }

    public String getImplementationPackageName() {
        return this.fromSuffixToPackageName(this.implementationSuffix);
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackage(String entityPackage) {
        this.entityPackageName = entityPackage;
    }

    public String getViewExtension() {
        return this.viewExtension;
    }

    public void setViewExtension(String viewExtension) {
        this.viewExtension = viewExtension;
    }

    public String getViewRootPath() {
        return this.viewRootPath;
    }

    public void setViewRootPath(String viewRootPath) {
        this.viewRootPath = viewRootPath;
    }

    public String getSubApplicationRootPackageName() {
        return this.subApplicationRootPackageName;
    }

    public void setSubApplicationRootPackageName(String subApplicationRootPackageName) {
        this.subApplicationRootPackageName = subApplicationRootPackageName;
    }

    public String[] getRootPackageNames() {
        return this.rootPackageNames;
    }

    public void addRootPackageName(String rootPackageName) {
        this.rootPackageNames = (String[])ArrayUtil.add((Object[])this.rootPackageNames, rootPackageName);
        this.addExistChecker(rootPackageName);
    }

    public String fromSuffixToPackageName(String suffix) {
        if (StringUtil.isEmpty(suffix)) {
            throw new EmptyRuntimeException("suffix");
        }
        return StringUtil.decapitalize(suffix);
    }

    public String fromClassNameToShortComponentName(String className) {
        if (StringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String s = StringUtil.decapitalize(ClassUtil.getShortClassName(className));
        if (s.endsWith(this.implementationSuffix)) {
            return s.substring(0, s.length() - this.implementationSuffix.length());
        }
        return s;
    }

    public String fromClassNameToComponentName(String className) {
        if (StringUtil.isEmpty(className)) {
            throw new EmptyRuntimeException("className");
        }
        String cname = this.toInterfaceClassName(className);
        String suffix = this.fromClassNameToSuffix(cname);
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String key = "." + middlePackageName + ".";
        int index = cname.indexOf(key);
        String name = null;
        if (index > 0) {
            name = cname.substring(index + key.length());
        } else {
            key = "." + this.subApplicationRootPackageName + ".";
            index = cname.indexOf(key);
            if (index < 0) {
                return this.fromClassNameToShortComponentName(className);
            }
            name = cname.substring(index + key.length());
        }
        String[] array = StringUtil.split(name, ".");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i == array.length - 1) {
                buf.append(StringUtil.decapitalize(array[i]));
                continue;
            }
            buf.append(array[i]);
            buf.append('_');
        }
        return buf.toString();
    }

    public Class fromComponentNameToClass(String componentName) {
        if (StringUtil.isEmpty(componentName)) {
            throw new EmptyRuntimeException("componentName");
        }
        String suffix = this.fromComponentNameToSuffix(componentName);
        if (suffix == null) {
            return null;
        }
        String middlePackageName = this.fromSuffixToPackageName(suffix);
        String partOfClassName = this.fromComponentNameToPartOfClassName(componentName);
        boolean subAppSuffix = this.isSubApplicationSuffix(suffix);
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            Class clazz;
            String rootPackageName = this.rootPackageNames[i];
            if (subAppSuffix) {
                clazz = this.findClass(rootPackageName, this.subApplicationRootPackageName, partOfClassName);
                if (clazz != null) {
                    return clazz;
                }
                clazz = this.findClass(rootPackageName, middlePackageName, partOfClassName);
                if (clazz == null) continue;
                return clazz;
            }
            clazz = this.findClass(rootPackageName, middlePackageName, partOfClassName);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findClass(rootPackageName, this.subApplicationRootPackageName, partOfClassName);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    protected boolean isSubApplicationSuffix(String suffix) {
        if (this.pageSuffix.equals(suffix)) {
            return true;
        }
        if (this.dxoSuffix.equals(suffix)) {
            return true;
        }
        if (this.actionSuffix.equals(suffix)) {
            return true;
        }
        return this.serviceSuffix.equals(suffix);
    }

    protected Class findClass(String rootPackageName, String middlePackageName, String partOfClassName) {
        this.initialize();
        String lastClassName = ClassUtil.concatName(middlePackageName, partOfClassName);
        String className = ClassUtil.concatName(rootPackageName, lastClassName);
        if (this.isExist(rootPackageName, lastClassName)) {
            String lastImplClassName;
            Class clazz = ClassUtil.forName(className);
            if (clazz.isInterface() && this.isExist(rootPackageName, lastImplClassName = this.toImplementationClassName(lastClassName))) {
                String implClassName = ClassUtil.concatName(rootPackageName, lastImplClassName);
                clazz = ClassUtil.forName(implClassName);
            }
            return clazz;
        }
        return null;
    }

    public String toImplementationClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return this.getImplementationPackageName() + "." + className + this.implementationSuffix;
        }
        return className.substring(0, index) + "." + this.getImplementationPackageName() + "." + className.substring(index + 1) + this.implementationSuffix;
    }

    public String toInterfaceClassName(String className) {
        if (!className.endsWith(this.implementationSuffix)) {
            return className;
        }
        String key = "." + this.getImplementationPackageName() + ".";
        int index = className.lastIndexOf(key);
        if (index < 0) {
            throw new IllegalArgumentException(className);
        }
        return className.substring(0, index) + "." + className.substring(index + key.length(), className.length() - this.implementationSuffix.length());
    }

    public Class toCompleteClass(Class clazz) {
        if (!clazz.isInterface()) {
            return clazz;
        }
        String className = this.toImplementationClassName(clazz.getName());
        if (ResourceUtil.isExist(ClassUtil.getResourcePath(className))) {
            return ClassUtil.forName(className);
        }
        return clazz;
    }

    public String fromComponentNameToPartOfClassName(String componentName) {
        if (componentName == null) {
            throw new EmptyRuntimeException("componentName");
        }
        String[] names = StringUtil.split(componentName, PACKAGE_SEPARATOR_STR);
        StringBuffer buf = new StringBuffer(50);
        for (int i = 0; i < names.length; ++i) {
            if (i == names.length - 1) {
                buf.append(StringUtil.capitalize(names[i]));
                continue;
            }
            buf.append(names[i]).append(".");
        }
        return buf.toString();
    }

    public String fromComponentNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    public String fromClassNameToSuffix(String componentName) {
        return this.fromNameToSuffix(componentName);
    }

    protected String fromNameToSuffix(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new EmptyRuntimeException("name");
        }
        for (int i = name.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            return name.substring(i);
        }
        return null;
    }

    public String fromPathToPageName(String path) {
        return this.fromPathToComponentName(path, this.pageSuffix);
    }

    protected String fromPathToComponentName(String path, String nameSuffix) {
        if (!path.startsWith(this.viewRootPath) || !path.endsWith(this.viewExtension)) {
            throw new IllegalArgumentException(path);
        }
        String componentName = path.substring(this.viewRootPath.length() + 1, path.length() - this.viewExtension.length()) + nameSuffix;
        return componentName.replace('/', '_');
    }

    public String fromPathToActionName(String path) {
        return this.fromPathToComponentName(path, this.actionSuffix);
    }

    public String fromPageNameToPath(String pageName) {
        if (!pageName.endsWith(this.pageSuffix)) {
            throw new IllegalArgumentException(pageName);
        }
        String name = pageName.substring(0, pageName.length() - this.pageSuffix.length());
        return this.viewRootPath + "/" + name.replace('_', '/') + this.viewExtension;
    }

    public String fromActionNameToPath(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        String name = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        return this.viewRootPath + "/" + name.replace('_', '/') + this.viewExtension;
    }

    public String fromActionNameToPageName(String actionName) {
        if (!actionName.endsWith(this.actionSuffix)) {
            throw new IllegalArgumentException(actionName);
        }
        return actionName.substring(0, actionName.length() - this.actionSuffix.length()) + this.pageSuffix;
    }

    public boolean isTargetClassName(String className, String suffix) {
        String name = StringUtil.trimSuffix(className, this.implementationSuffix);
        return name.endsWith(suffix);
    }

    public boolean isTargetClassName(String className) {
        for (int i = 0; i < this.rootPackageNames.length; ++i) {
            if (!className.startsWith(this.rootPackageNames[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isExist(String rootPackageName, String lastClassName) {
        ExistChecker[] checkerArray = this.getExistCheckerArray(rootPackageName);
        for (int i = 0; i < checkerArray.length; ++i) {
            if (!checkerArray[i].isExist(lastClassName)) continue;
            return true;
        }
        return false;
    }

    protected ExistChecker[] getExistCheckerArray(String rootPackageName) {
        return (ExistChecker[])this.existCheckerArrays.get(rootPackageName);
    }

    protected void addExistChecker(String rootPackageName) {
        ExistChecker[] checkerArray = this.createExistCheckerArray(rootPackageName);
        this.existCheckerArrays.put(rootPackageName, checkerArray);
    }

    protected ExistChecker[] createExistCheckerArray(String rootPackageName) {
        if (StringUtil.isEmpty(rootPackageName)) {
            return new ExistChecker[0];
        }
        String s = rootPackageName.replace('.', '/');
        ArrayList<ExistChecker> list = new ArrayList<ExistChecker>();
        Iterator it = ClassLoaderUtil.getResources(this.getClass(), s);
        while (it.hasNext()) {
            URL url = (URL)it.next();
            if (url.getProtocol().equals("file")) {
                list.add(new FileExistChecker(url));
                continue;
            }
            list.add(new JarExistChecker(url, rootPackageName));
        }
        return list.toArray(new ExistChecker[list.size()]);
    }

    protected static String getPathName(String lastClassName) {
        return lastClassName.replace('.', '/') + ".class";
    }

    protected static class JarExistChecker
    implements ExistChecker {
        private JarFile jarFile;
        private String rootPath;

        protected JarExistChecker(URL jarUrl, String rootPackageName) {
            this.jarFile = JarFileUtil.create(JarFileUtil.toJarFilePath(jarUrl));
            this.rootPath = rootPackageName.replace('.', '/') + "/";
        }

        public boolean isExist(String lastClassName) {
            return this.jarFile.getEntry(this.rootPath + NamingConventionImpl.getPathName(lastClassName)) != null;
        }
    }

    protected static class FileExistChecker
    implements ExistChecker {
        private File rootFile;

        protected FileExistChecker(URL rootUrl) {
            this.rootFile = URLUtil.toFile(rootUrl);
        }

        public boolean isExist(String lastClassName) {
            File file = new File(this.rootFile, NamingConventionImpl.getPathName(lastClassName));
            return file.exists();
        }
    }

    protected static interface ExistChecker {
        public boolean isExist(String var1);
    }
}

