/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.deployer.AbstractComponentDeployer;
import org.seasar.framework.exception.EmptyRuntimeException;

public class SessionComponentDeployer
extends AbstractComponentDeployer {
    public SessionComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object deploy() {
        String componentName;
        ComponentDef cd = this.getComponentDef();
        ExternalContext extCtx = cd.getContainer().getRoot().getExternalContext();
        if (extCtx == null) {
            throw new EmptyRuntimeException("externalContext");
        }
        Map sessionMap = extCtx.getSessionMap();
        Object old = sessionMap.get(componentName = this.getComponentName());
        if (old != null && old.getClass().equals(cd.getConcreteClass())) {
            return old;
        }
        Object component = this.getConstructorAssembler().assemble();
        if (old != null) {
            this.copyProperties(old, component);
        } else {
            this.getPropertyAssembler().assemble(component);
            this.getInitMethodAssembler().assemble(component);
        }
        sessionMap.put(componentName, component);
        return component;
    }

    protected void copyProperties(Object old, Object component) {
        BeanDesc oldBeanDesc = BeanDescFactory.getBeanDesc(old.getClass());
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod()) continue;
            PropertyDesc oldPd = oldBeanDesc.getPropertyDesc(pd.getPropertyName());
            if (!pd.hasReadMethod()) continue;
            pd.setValue(component, oldPd.getValue(old));
        }
    }

    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    public void init() {
    }

    public void destroy() {
    }
}

