/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.log.Logger;

public class TraceInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -8142348754572405060L;
    private static final Logger logger = Logger.getLogger(TraceInterceptor.class);
    protected int maxLengthOfCollection = 10;

    public void setMaxLengthOfCollection(int maxLengthOfCollection) {
        this.maxLengthOfCollection = maxLengthOfCollection;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getTargetClass(invocation).getName());
        buf.append("#").append(invocation.getMethod().getName()).append("(");
        Object[] args = invocation.getArguments();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                this.appendObject(buf, args[i]).append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        Object ret = null;
        Throwable cause = null;
        logger.debug("BEGIN " + buf);
        try {
            ret = invocation.proceed();
            buf.append(" : ");
            this.appendObject(buf, ret);
        }
        catch (Throwable t) {
            buf.append(" Throwable:").append(t);
            cause = t;
        }
        logger.debug("END " + buf);
        if (cause == null) {
            return ret;
        }
        throw cause;
    }

    protected StringBuffer appendObject(StringBuffer buf, Object arg) {
        if (arg == null) {
            buf.append("null");
        } else if (arg.getClass().isArray()) {
            this.appendList(buf, Arrays.asList((Object[])arg));
        } else if (arg instanceof Collection) {
            this.appendList(buf, (Collection)arg);
        } else {
            buf.append(arg);
        }
        return buf;
    }

    protected StringBuffer appendList(StringBuffer buf, Collection collection) {
        int count;
        buf.append("[");
        Iterator it = collection.iterator();
        for (count = 0; it.hasNext() && count < this.maxLengthOfCollection; ++count) {
            this.appendObject(buf, it.next()).append(", ");
        }
        if (count > 0) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("]");
        return buf;
    }
}

