/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;

public class RemoveSessionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    protected S2Container container;
    protected String name;

    public RemoveSessionInterceptor(S2Container container) {
        this.container = container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.removeSession();
        }
    }

    protected void removeSession() {
        ExternalContext context = this.container.getRoot().getExternalContext();
        if (context == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        if (request == null) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute(this.name);
    }
}

