/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.parser;

import org.seasar.extension.sql.SqlTokenizer;
import org.seasar.extension.sql.TokenNotClosedRuntimeException;

public class SqlTokenizerImpl
implements SqlTokenizer {
    private String sql;
    private int position = 0;
    private String token;
    private int tokenType = 1;
    private int nextTokenType = 1;
    private int bindVariableNum = 0;

    public SqlTokenizerImpl(String sql) {
        this.sql = sql;
    }

    public int getPosition() {
        return this.position;
    }

    public String getToken() {
        return this.token;
    }

    public String getBefore() {
        return this.sql.substring(0, this.position);
    }

    public String getAfter() {
        return this.sql.substring(this.position);
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public int getNextTokenType() {
        return this.nextTokenType;
    }

    public int next() {
        if (this.position >= this.sql.length()) {
            this.token = null;
            this.tokenType = 99;
            this.nextTokenType = 99;
            return this.tokenType;
        }
        switch (this.nextTokenType) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
                break;
            }
            default: {
                this.parseEof();
            }
        }
        return this.tokenType;
    }

    protected void parseSql() {
        int nextStartPos;
        int skipPos;
        int commentStartPos = this.sql.indexOf("/*", this.position);
        int commentStartPos2 = this.sql.indexOf("#*", this.position);
        if (0 < commentStartPos2 && commentStartPos2 < commentStartPos) {
            commentStartPos = commentStartPos2;
        }
        int lineCommentStartPos = this.sql.indexOf("--", this.position);
        int bindVariableStartPos = this.sql.indexOf("?", this.position);
        int elseCommentStartPos = -1;
        int elseCommentLength = -1;
        if (lineCommentStartPos >= 0 && (skipPos = this.skipWhitespace(lineCommentStartPos + 2)) + 4 < this.sql.length() && "ELSE".equals(this.sql.substring(skipPos, skipPos + 4))) {
            elseCommentStartPos = lineCommentStartPos;
            elseCommentLength = skipPos + 4 - lineCommentStartPos;
        }
        if ((nextStartPos = this.getNextStartPos(commentStartPos, elseCommentStartPos, bindVariableStartPos)) < 0) {
            this.token = this.sql.substring(this.position);
            this.nextTokenType = 99;
            this.position = this.sql.length();
            this.tokenType = 1;
        } else {
            boolean needNext;
            this.token = this.sql.substring(this.position, nextStartPos);
            this.tokenType = 1;
            boolean bl = needNext = nextStartPos == this.position;
            if (nextStartPos == commentStartPos) {
                this.nextTokenType = 2;
                this.position = commentStartPos + 2;
            } else if (nextStartPos == elseCommentStartPos) {
                this.nextTokenType = 3;
                this.position = elseCommentStartPos + elseCommentLength;
            } else if (nextStartPos == bindVariableStartPos) {
                this.nextTokenType = 4;
                this.position = bindVariableStartPos;
            }
            if (needNext) {
                this.next();
            }
        }
    }

    protected int getNextStartPos(int commentStartPos, int elseCommentStartPos, int bindVariableStartPos) {
        int nextStartPos = -1;
        if (commentStartPos >= 0) {
            nextStartPos = commentStartPos;
        }
        if (elseCommentStartPos >= 0 && (nextStartPos < 0 || elseCommentStartPos < nextStartPos)) {
            nextStartPos = elseCommentStartPos;
        }
        if (bindVariableStartPos >= 0 && (nextStartPos < 0 || bindVariableStartPos < nextStartPos)) {
            nextStartPos = bindVariableStartPos;
        }
        return nextStartPos;
    }

    protected String nextBindVariableName() {
        return "$" + ++this.bindVariableNum;
    }

    protected void parseComment() {
        int commentEndPos = this.sql.indexOf("*/", this.position);
        int commentEndPos2 = this.sql.indexOf("*#", this.position);
        if (0 < commentEndPos2 && commentEndPos2 < commentEndPos) {
            commentEndPos = commentEndPos2;
        }
        if (commentEndPos < 0) {
            throw new TokenNotClosedRuntimeException("*/", this.sql.substring(this.position));
        }
        this.token = this.sql.substring(this.position, commentEndPos);
        this.nextTokenType = 1;
        this.position = commentEndPos + 2;
        this.tokenType = 2;
    }

    protected void parseBindVariable() {
        this.token = this.nextBindVariableName();
        this.nextTokenType = 1;
        ++this.position;
        this.tokenType = 4;
    }

    protected void parseElse() {
        this.token = null;
        this.nextTokenType = 1;
        this.tokenType = 3;
    }

    protected void parseEof() {
        this.token = null;
        this.tokenType = 99;
        this.nextTokenType = 99;
    }

    public String skipToken() {
        int i;
        boolean quoting;
        int index = this.sql.length();
        char quote = this.position < this.sql.length() ? this.sql.charAt(this.position) : (char)'\u0000';
        boolean bl = quoting = quote == '\'' || quote == '(';
        if (quote == '(') {
            quote = ')';
        }
        int n = i = quoting ? this.position + 1 : this.position;
        while (i < this.sql.length()) {
            char c = this.sql.charAt(i);
            if ((Character.isWhitespace(c) || c == ',' || c == ')' || c == '(') && !quoting) {
                index = i;
                break;
            }
            if (c == '/' && i + 1 < this.sql.length() && this.sql.charAt(i + 1) == '*') {
                index = i;
                break;
            }
            if (c == '-' && i + 1 < this.sql.length() && this.sql.charAt(i + 1) == '-') {
                index = i;
                break;
            }
            if (quoting && quote == '\'' && c == '\'' && (i + 1 >= this.sql.length() || this.sql.charAt(i + 1) != '\'')) {
                index = i + 1;
                break;
            }
            if (quoting && c == quote) {
                index = i + 1;
                break;
            }
            ++i;
        }
        this.token = this.sql.substring(this.position, index);
        this.tokenType = 1;
        this.nextTokenType = 1;
        this.position = index;
        return this.token;
    }

    public String skipWhitespace() {
        int index = this.skipWhitespace(this.position);
        this.token = this.sql.substring(this.position, index);
        this.position = index;
        return this.token;
    }

    private int skipWhitespace(int position) {
        int index = this.sql.length();
        for (int i = position; i < this.sql.length(); ++i) {
            char c = this.sql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            index = i;
            break;
        }
        return index;
    }
}

