/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.util.StringConversionUtil;

public class CharacterType
implements ValueType {
    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.toCharacter(resultSet.getString(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.toCharacter(resultSet.getString(columnName));
    }

    private Character toCharacter(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        if (chars.length == 1) {
            return new Character(chars[0]);
        }
        if (chars.length == 0) {
            return null;
        }
        throw new IllegalStateException("length of String should be 1. actual is [" + value + "]");
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 1);
        } else {
            ps.setString(index, StringConversionUtil.toString((Object)value));
        }
    }
}

