/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.util.DxoUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.OgnlUtil;
import org.seasar.framework.util.StringUtil;

public class ConversionContextImpl
implements ConversionContext {
    protected static boolean initialized;
    protected static final Map contextCache;
    protected Class dxoClass;
    protected Method method;
    protected ConverterFactory converterFactory;
    protected Map convertedObjects = new IdentityHashMap();
    protected Map contextInfo;
    protected Map evaluatedValues;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                ConversionContextImpl.destroy();
            }
        });
        initialized = true;
    }

    public static synchronized void destroy() {
        contextCache.clear();
        initialized = false;
    }

    public ConversionContextImpl(Class dxoClass, Method method, ConverterFactory converterFactory, AnnotationReader reader, Object source) {
        ConversionContextImpl.initialize();
        this.dxoClass = dxoClass;
        this.method = method;
        this.converterFactory = converterFactory;
        this.contextInfo = this.getContextInfo(reader);
        Object conversionRule = this.getContextInfo("CONVERSION_RULE");
        if (conversionRule != null) {
            this.evaluatedValues = (Map)OgnlUtil.getValue((Object)conversionRule, (Object)source);
        }
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public void addConvertedObject(Object source, Object dest) {
        this.convertedObjects.put(source, dest);
    }

    public Object getConvertedObject(Object source) {
        return this.convertedObjects.get(source);
    }

    public Object getContextInfo(String key) {
        return this.contextInfo.get(key);
    }

    public boolean hasEvalueatedValue(String name) {
        if (this.evaluatedValues == null) {
            return false;
        }
        return this.evaluatedValues.containsKey(name);
    }

    public Object getEvaluatedValue(String name) {
        if (this.evaluatedValues == null) {
            return null;
        }
        return this.evaluatedValues.get(name);
    }

    protected Map getContextInfo(AnnotationReader reader) {
        Map contextInfo = (Map)contextCache.get(this.method);
        if (contextInfo != null) {
            return contextInfo;
        }
        return this.createContextInfo(reader);
    }

    protected Map createContextInfo(AnnotationReader reader) {
        HashMap<String, Object> contextInfo = new HashMap<String, Object>();
        contextInfo.put("DATE_PATTERN", this.toDateFormat(reader.getDatePattern(this.dxoClass, this.method)));
        contextInfo.put("TIME_PATTERN", this.toDateFormat(reader.getTimePattern(this.dxoClass, this.method)));
        contextInfo.put("TIMESTAMP_PATTERN", this.toDateFormat(reader.getTimestampPattern(this.dxoClass, this.method)));
        String conversionRule = reader.getConversionRule(this.dxoClass, this.method);
        if (!StringUtil.isEmpty((String)conversionRule)) {
            contextInfo.put("CONVERSION_RULE", DxoUtil.parseMap(conversionRule));
        }
        return contextInfo;
    }

    protected DateFormat toDateFormat(String format) {
        if (StringUtil.isEmpty((String)format)) {
            return null;
        }
        return new SimpleDateFormat(format);
    }

    static {
        contextCache = Collections.synchronizedMap(new HashMap());
    }
}

