/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.builder.impl;

import [Ljava.util.Map;;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.seasar.extension.dxo.builder.impl.AbstractDxoCommandBuilder;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.command.impl.BeanToMapDxoCommand;

public class BeanToMapDxoCommandBuilder
extends AbstractDxoCommandBuilder {
    protected Class[] ACCEPTABLE_DEST_CLASSES = new Class[]{Map.class, Map;.class, List.class};

    public DxoCommand createDxoCommand(Class dxoClass, Method method) {
        Class<?> destType;
        String expression = this.getAnnotationReader().getConversionRule(dxoClass, method);
        if (expression == null) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            return null;
        }
        Class<?> sourceType = parameterTypes[0];
        Class<?> clazz = destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        if (destType.isArray()) {
            Class<?> elementType = destType.getComponentType();
            if (!elementType.isAssignableFrom(Map.class)) {
                return null;
            }
            if (!sourceType.isArray() && !List.class.isAssignableFrom(sourceType)) {
                return null;
            }
        } else if (List.class.isAssignableFrom(destType)) {
            Class elementType = BeanToMapDxoCommandBuilder.getElementTypeOfListFromDestination(method);
            if (elementType != null && !elementType.isAssignableFrom(Map.class)) {
                return null;
            }
            if (!sourceType.isArray() && !List.class.isAssignableFrom(sourceType)) {
                return null;
            }
        } else if (!destType.isAssignableFrom(Map.class)) {
            return null;
        }
        return new BeanToMapDxoCommand(method, expression);
    }
}

