/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.builder.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.seasar.extension.dxo.builder.impl.AbstractDxoCommandBuilder;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.command.impl.BeanToBeanDxoCommand;
import org.seasar.extension.dxo.converter.ConverterFactory;

public class BeanToBeanDxoCommandBuilder
extends AbstractDxoCommandBuilder {
    protected ConverterFactory converterFactory;

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public DxoCommand createDxoCommand(Class dxoClass, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            return null;
        }
        Class<?> sourceType = parameterTypes[0];
        Class sourceElementClass = BeanToBeanDxoCommandBuilder.getElementTypeOfListFromParameterType(method, 0);
        Class<?> destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        Class destElementClass = BeanToBeanDxoCommandBuilder.getElementTypeOfListFromDestination(method);
        if (sourceType.isArray()) {
            if (destType.isArray()) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), sourceType.getComponentType(), destType.getComponentType());
            }
            if (List.class.isAssignableFrom(destType) && destElementClass != null) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), sourceType.getComponentType(), destElementClass);
            }
        } else if (List.class.isAssignableFrom(sourceType) && sourceElementClass != null) {
            if (destType.isArray()) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), sourceElementClass, destType.getComponentType());
            }
            if (List.class.isAssignableFrom(destType)) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), sourceElementClass, destElementClass);
            }
        } else if (!destType.isArray() && !List.class.isAssignableFrom(destType)) {
            return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), sourceType, destType);
        }
        return null;
    }
}

