/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.TableReader;
import org.seasar.extension.dataset.impl.DataTableResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.StringUtil;

public class SqlTableReader
implements TableReader {
    private DataSource dataSource_;
    private String tableName_;
    private String sql_;

    public SqlTableReader(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public String getTableName() {
        return this.tableName_;
    }

    public String getSql() {
        return this.sql_;
    }

    public void setTable(String tableName) {
        this.setTable(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(String tableName, String condition) {
        StringBuffer sortBuf = new StringBuffer(100);
        String[] primaryKeys = null;
        Connection con = DataSourceUtil.getConnection(this.dataSource_);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData(con);
            primaryKeys = DatabaseMetaDataUtil.getPrimaryKeys(dbMetaData, tableName);
        }
        finally {
            ConnectionUtil.close(con);
        }
        if (primaryKeys.length > 0) {
            for (int i = 0; i < primaryKeys.length; ++i) {
                sortBuf.append(primaryKeys[i]);
                sortBuf.append(", ");
            }
            sortBuf.setLength(sortBuf.length() - 2);
        }
        this.setTable(tableName, condition, sortBuf.toString());
    }

    public void setTable(String tableName, String condition, String sort) {
        this.tableName_ = tableName;
        StringBuffer sqlBuf = new StringBuffer(100);
        sqlBuf.append("SELECT * FROM ");
        sqlBuf.append(tableName);
        if (!StringUtil.isEmpty((String)condition)) {
            sqlBuf.append(" WHERE ");
            sqlBuf.append(condition);
        }
        if (!StringUtil.isEmpty((String)sort)) {
            sqlBuf.append(" ORDER BY ");
            sqlBuf.append(sort);
        }
        this.sql_ = sqlBuf.toString();
    }

    public void setSql(String sql, String tableName) {
        this.sql_ = sql;
        this.tableName_ = tableName;
    }

    public DataTable read() {
        BasicSelectHandler selectHandler = new BasicSelectHandler(this.dataSource_, this.sql_, new DataTableResultSetHandler(this.tableName_));
        return (DataTable)selectHandler.execute((Object[])null);
    }
}

