/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.component.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.seasar.extension.component.ComponentInvoker;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;

public class ComponentInvokerImpl
implements ComponentInvoker {
    private S2Container container;
    private boolean ondemand;

    public Object invoke(String componentName, String methodName, Object[] args) throws Throwable {
        Object component = this.container.getRoot().getComponent((Object)componentName);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        try {
            if (this.ondemand) {
                this.redeserialize(args);
            }
            return beanDesc.invoke(component, methodName, args);
        }
        catch (InvocationTargetRuntimeException e) {
            throw e.getCause();
        }
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setOndemand(boolean ondemand) {
        this.ondemand = ondemand;
    }

    protected void redeserialize(Object[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(args[i]);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                args[i] = ois.readObject();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }
}

