/*
 * Decompiled with CFR 0.152.
 */
package org.nancle.validate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validates {
    private Validates() {
    }

    public static final boolean required(String string) {
        return string == null || string.length() <= 0;
    }

    public static final boolean maxLength(String string, int n) {
        if (string == null) {
            return false;
        }
        return string == null || string.length() > n;
    }

    public static final boolean minLength(String string, int n) {
        if (string == null) {
            return true;
        }
        return string == null || string.length() < n;
    }

    public static final boolean formatOf(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.matches();
        return !bl;
    }

    public static final boolean email(String string) {
        return Validates.formatOf(string, "^([^@\\s]+)@((?:[-a-z0-9]+\\.)+[a-z]{2,})$");
    }

    public static final boolean numeric(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return false;
    }
}

