/*
 * Decompiled with CFR 0.152.
 */
package org.nancle.context;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nancle.error.ErrorRenderer;
import org.nancle.error.Errors;

public class NancleContext {
    private static ThreadLocal<ServletContext> servletContext = new ThreadLocal();
    private static ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private static ThreadLocal<Errors> errors = new ThreadLocal();
    private static ThreadLocal<ErrorRenderer> errorRenderer = new ThreadLocal();

    public static void enter(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Errors errors, ErrorRenderer errorRenderer) {
        NancleContext.servletContext.set(servletContext);
        request.set(httpServletRequest);
        response.set(httpServletResponse);
        NancleContext.errors.set(errors);
        NancleContext.errorRenderer.set(errorRenderer);
    }

    public static ServletContext getServletContext() {
        return servletContext.get();
    }

    public static HttpServletRequest getRequest() {
        return request.get();
    }

    public static HttpServletResponse getResponse() {
        return response.get();
    }

    public static Errors getErrors() {
        return errors.get();
    }

    public static void setErrorRenderer(ErrorRenderer errorRenderer) {
        NancleContext.errorRenderer.set(errorRenderer);
    }

    public static ErrorRenderer getErrorRenderer() {
        return errorRenderer.get();
    }

    public static void leave() {
        servletContext.set(null);
        request.set(null);
        response.set(null);
        errors.set(null);
        errorRenderer.set(null);
    }
}

